import datetime

from yacs.config import CfgNode as CN

_C = CN()

# General settings
_C.agent_path = 'TD3_BC/agents/'

# WANDB settings
_C.wandb = CN()
_C.wandb.enable = True
_C.wandb.project_name = ''
_C.wandb.name = ''

_C.data = CN()
_C.data.path = ''
_C.data.use_d4rl = True
_C.data.noise_coeff = 0.0

# System parameters
_C.system = CN()
_C.system.cpu = False

# Environment
_C.env = CN()
_C.env.type = ''


def get_cfg_defaults(config_file=None, config_list=None):
    cfg = _C.clone()
    if config_file is not None:
        cfg.merge_from_file(config_file)
    if config_list is not None:
        cfg.merge_from_list(config_list)
    cfg.freeze()
    return cfg
