from .env.halfcheetah import default_config as halfcheetah_default_config
from .env.hopper import default_config as hopper_default_config
from .env.walker2d import default_config as walker2d_default_config


def get_algo_config(env_type):
    if env_type == 'HalfCheetah':
        return halfcheetah_default_config
    elif env_type == 'Hopper':
        return hopper_default_config
    elif env_type == 'Walker2d':
        return walker2d_default_config
    else:
        raise ValueError(f'{env_type} is not supprted. Use [halfcheetah/hopper/walker2d]')
