import numpy as np
import torch
import d4rl
import gym

import utils

def create_noise_vec(dataset_shape, seed, name):
    utils.set_seed(seed)
    noise_vec = np.random.randn(*dataset_shape)
    torch.save(noise_vec, name)

if __name__ == '__main__':
    seed = 0
    env = 'halfcheetah-random'
    dataset_shape = gym.make(f'{env}-v2').get_dataset()['observations'].shape
    create_noise_vec(dataset_shape, seed, f'{env}.pkl')
