"""
Mapping_P3_prompt_names_to:
__underlying_dataset
__task_(!=_underlying_dataset,_since_some_prompts_change_the_nature_of_the_task,_e.g._generate_the_question_based_on_the_answer_instead_of_vice_versa.)
"""
from typing import Dict, List, Tuple

PROMPT_MAPPING: Dict[str, Tuple[str, str]] = {
    "adversarial_qa_dbert_answer_the_following_q": ("adversarial_qa_answer", "adversarial_qa"),
    "adversarial_qa_dbert_based_on": ("adversarial_qa_answer", "adversarial_qa"),
    "adversarial_qa_dbert_generate_question": (
        "adversarial_qa_generate_question",
        "adversarial_qa",
    ),
    "adversarial_qa_dbert_question_context_answer": ("adversarial_qa_answer", "adversarial_qa"),
    "adversarial_qa_dbert_tell_what_it_is": ("adversarial_qa_answer", "adversarial_qa"),
    "adversarial_qa_dbidaf_answer_the_following_q": ("adversarial_qa_answer", "adversarial_qa"),
    "adversarial_qa_dbidaf_based_on": ("adversarial_qa_answer", "adversarial_qa"),
    "adversarial_qa_dbidaf_generate_question": (
        "adversarial_qa_generate_question",
        "adversarial_qa",
    ),
    "adversarial_qa_dbidaf_question_context_answer": ("adversarial_qa_answer", "adversarial_qa"),
    "adversarial_qa_dbidaf_tell_what_it_is": ("adversarial_qa_answer", "adversarial_qa"),
    "adversarial_qa_droberta_answer_the_following_q": ("adversarial_qa_answer", "adversarial_qa"),
    "adversarial_qa_droberta_based_on": ("adversarial_qa_answer", "adversarial_qa"),
    "adversarial_qa_droberta_generate_question": (
        "adversarial_qa_generate_question",
        "adversarial_qa",
    ),
    "adversarial_qa_droberta_question_context_answer": ("adversarial_qa_answer", "adversarial_qa"),
    "adversarial_qa_droberta_tell_what_it_is": ("adversarial_qa_answer", "adversarial_qa"),
    "ag_news_classify": ("ag_news", "ag_news"),
    "ag_news_classify_question_first": ("ag_news", "ag_news"),
    "ag_news_classify_with_choices": ("ag_news", "ag_news"),
    "ag_news_classify_with_choices_question_first": ("ag_news", "ag_news"),
    "ag_news_recommend": ("ag_news", "ag_news"),
    "ag_news_which_section": ("ag_news", "ag_news"),
    "ag_news_which_section_choices": ("ag_news", "ag_news"),
    "amazon_polarity_Is_this_product_review_positive": ("amazon_polarity", "amazon_polarity"),
    "amazon_polarity_Is_this_review": ("amazon_polarity", "amazon_polarity"),
    "amazon_polarity_Is_this_review_negative": ("amazon_polarity", "amazon_polarity"),
    "amazon_polarity_User_recommend_this_product": ("amazon_polarity", "amazon_polarity"),
    "amazon_polarity_convey_negative_or_positive_sentiment": ("amazon_polarity", "amazon_polarity"),
    "amazon_polarity_flattering_or_not": ("amazon_polarity", "amazon_polarity"),
    "amazon_polarity_negative_or_positive_tone": ("amazon_polarity", "amazon_polarity"),
    "amazon_polarity_user_satisfied": ("amazon_polarity", "amazon_polarity"),
    "amazon_polarity_would_you_buy": ("amazon_polarity", "amazon_polarity"),
    "app_reviews_categorize_rating_using_review": ("app_reviews_review", "app_reviews"),
    "app_reviews_convert_to_rating": ("app_reviews_review", "app_reviews"),
    "app_reviews_convert_to_star_rating": ("app_reviews_review", "app_reviews"),
    "app_reviews_generate_review": ("app_reviews_generate", "app_reviews"),
    "cnn_dailymail_3.0.0_2_or_3_sentences": (
        "cnn_dailymail_3.0.0_summarise",
        "cnn_dailymail_3.0.0",
    ),
    "cnn_dailymail_3.0.0_generate_story": ("cnn_dailymail_3.0.0_generate", "cnn_dailymail_3.0.0"),
    "cnn_dailymail_3.0.0_news_card_view": ("cnn_dailymail_3.0.0_summarise", "cnn_dailymail_3.0.0"),
    "cnn_dailymail_3.0.0_news_stock": ("cnn_dailymail_3.0.0_summarise", "cnn_dailymail_3.0.0"),
    "cnn_dailymail_3.0.0_news_summary": ("cnn_dailymail_3.0.0_summarise", "cnn_dailymail_3.0.0"),
    "cnn_dailymail_3.0.0_spice_up_story": ("cnn_dailymail_3.0.0_generate", "cnn_dailymail_3.0.0"),
    "cnn_dailymail_3.0.0_sum_in_brief": ("cnn_dailymail_3.0.0_summarise", "cnn_dailymail_3.0.0"),
    "cnn_dailymail_3.0.0_tldr_summary": ("cnn_dailymail_3.0.0_summarise", "cnn_dailymail_3.0.0"),
    "cnn_dailymail_3.0.0_write_an_outline": (
        "cnn_dailymail_3.0.0_summarise",
        "cnn_dailymail_3.0.0",
    ),
    "common_gen_Example_prompt": ("common_gen_target", "common_gen"),
    "common_gen_Given_concepts_type_2": ("common_gen_target", "common_gen"),
    "common_gen_Given_concepts_type_1": ("common_gen_target", "common_gen"),
    "common_gen_Put_together": ("common_gen_target", "common_gen"),
    "common_gen_choice_in_concept_centric_sentence_generation": ("common_gen_target", "common_gen"),
    "common_gen_random_task_template_prompt": ("common_gen_target", "common_gen"),
    "common_gen_sentence_to_concepts": ("common_gen_concepts", "common_gen"),
    "common_gen_topic_to_sentence": ("common_gen_target", "common_gen"),
    "common_gen_topics_from_the_sentence": ("common_gen_concepts", "common_gen"),
    "cos_e_v1.11_aligned_with_common_sense": ("cos_e_v1.11_explain", "cos_e_v1.11"),
    "cos_e_v1.11_description_question_option_id": ("cos_e_v1.11_answer", "cos_e_v1.11"),
    "cos_e_v1.11_description_question_option_text": ("cos_e_v1.11_answer", "cos_e_v1.11"),
    "cos_e_v1.11_explain_why_human": ("cos_e_v1.11_explain", "cos_e_v1.11"),
    "cos_e_v1.11_generate_explanation_given_text": ("cos_e_v1.11_explain", "cos_e_v1.11"),
    "cos_e_v1.11_i_think": ("cos_e_v1.11_explain", "cos_e_v1.11"),
    "cos_e_v1.11_question_description_option_id": ("cos_e_v1.11_answer", "cos_e_v1.11"),
    "cos_e_v1.11_question_description_option_text": ("cos_e_v1.11_answer", "cos_e_v1.11"),
    "cos_e_v1.11_question_option_description_id": ("cos_e_v1.11_answer", "cos_e_v1.11"),
    "cos_e_v1.11_question_option_description_text": ("cos_e_v1.11_answer", "cos_e_v1.11"),
    "cos_e_v1.11_rationale": ("cos_e_v1.11_explain", "cos_e_v1.11"),
    "cosmos_qa_context_answer_to_question": ("cosmos_qa_generate_question", "cosmos_qa"),
    "cosmos_qa_context_description_question_answer_id": ("cosmos_qa_answer", "cosmos_qa"),
    "cosmos_qa_context_description_question_answer_text": ("cosmos_qa_answer", "cosmos_qa"),
    "cosmos_qa_context_description_question_text": ("cosmos_qa_answer", "cosmos_qa"),
    "cosmos_qa_context_question_description_answer_id": ("cosmos_qa_answer", "cosmos_qa"),
    "cosmos_qa_context_question_description_answer_text": ("cosmos_qa_answer", "cosmos_qa"),
    "cosmos_qa_context_question_description_text": ("cosmos_qa_answer", "cosmos_qa"),
    "cosmos_qa_description_context_question_answer_id": ("cosmos_qa_answer", "cosmos_qa"),
    "cosmos_qa_description_context_question_answer_text": ("cosmos_qa_answer", "cosmos_qa"),
    "cosmos_qa_description_context_question_text": ("cosmos_qa_answer", "cosmos_qa"),
    "cosmos_qa_no_prompt_id": ("cosmos_qa_answer", "cosmos_qa"),
    "cosmos_qa_no_prompt_text": ("cosmos_qa_answer", "cosmos_qa"),
    "cosmos_qa_only_question_answer": ("cosmos_qa_answer", "cosmos_qa"),
    "dbpedia_14_given_a_choice_of_categories_": ("dbpedia_14_answer", "dbpedia_14"),
    "dbpedia_14_given_a_list_of_category_what_does_the_title_belong_to": (
        "dbpedia_14_answer",
        "dbpedia_14",
    ),
    "dbpedia_14_given_list_what_category_does_the_paragraph_belong_to": (
        "dbpedia_14_answer",
        "dbpedia_14",
    ),
    "dbpedia_14_pick_one_category_for_the_following_text": ("dbpedia_14_answer", "dbpedia_14"),
    "dream_answer_to_dialogue": ("dream_dialogue", "dream"),
    "dream_baseline": ("dream_question_answer", "dream"),
    "dream_generate_first_utterance": ("dream_first_utterance", "dream"),
    "dream_generate_last_utterance": ("dream_last_utterance", "dream"),
    "dream_read_the_following_conversation_and_answer_the_question": (
        "dream_question_answer",
        "dream",
    ),
    "duorc_ParaphraseRC_answer_question": ("duorc_paraphraserc_answer", "duorc"),
    "duorc_ParaphraseRC_build_story_around_qa": ("duorc_paraphraserc_plot", "duorc"),
    "duorc_ParaphraseRC_decide_worth_it": ("duorc_paraphraserc_answer", "duorc"),
    "duorc_ParaphraseRC_extract_answer": ("duorc_paraphraserc_answer", "duorc"),
    "duorc_ParaphraseRC_generate_question": ("duorc_paraphrase_rc_question", "duorc"),
    "duorc_ParaphraseRC_generate_question_by_answer": ("duorc_paraphrase_rc_question", "duorc"),
    "duorc_ParaphraseRC_movie_director": ("duorc_paraphraserc_answer", "duorc"),
    "duorc_ParaphraseRC_question_answering": ("duorc_paraphraserc_answer", "duorc"),
    "duorc_ParaphraseRC_title_generation": ("duorc_paraphraserc_title", "duorc"),
    "duorc_SelfRC_answer_question": ("duorc_selfrc_answer", "duorc"),
    "duorc_SelfRC_build_story_around_qa": ("duorc_selfrc_plot", "duorc"),
    "duorc_SelfRC_decide_worth_it": ("duorc_selfrc_answer", "duorc"),
    "duorc_SelfRC_extract_answer": ("duorc_selfrc_answer", "duorc"),
    "duorc_SelfRC_generate_question": ("duorc_selfrc_question", "duorc"),
    "duorc_SelfRC_generate_question_by_answer": ("duorc_selfrc_question", "duorc"),
    "duorc_SelfRC_movie_director": ("duorc_selfrc_answer", "duorc"),
    "duorc_SelfRC_question_answering": ("duorc_selfrc_answer", "duorc"),
    "duorc_SelfRC_title_generation": ("duorc_selfrc_title", "duorc"),
    "gigaword_TLDR": ("gigaword_summary", "gigaword"),
    "gigaword_first_sentence_title": ("gigaword_summary", "gigaword"),
    "gigaword_generate_summary_for_this": ("gigaword_summary", "gigaword"),
    "gigaword_in_a_nutshell": ("gigaword_summary", "gigaword"),
    "gigaword_make_a_title": ("gigaword_summary", "gigaword"),
    "gigaword_reverse_writing": ("gigaword_generate", "gigaword"),
    "gigaword_write_a_title_for_this_sentence": ("gigaword_summary", "gigaword"),
    "gigaword_write_an_article": ("gigaword_generate", "gigaword"),
    "gigaword_write_its_sentence": ("gigaword_summary", "gigaword"),
    "glue_qqp_answer": ("glue_qqp_answer", "glue"),
    "glue_qqp_duplicate": ("glue_qqp_answer", "glue"),
    "glue_qqp_duplicate_or_not": ("glue_qqp_answer", "glue"),
    "glue_qqp_meaning": ("glue_qqp_answer", "glue"),
    "glue_qqp_quora": ("glue_qqp_answer", "glue"),
    "glue_qqp_same_thing": ("glue_qqp_answer", "glue"),
    "glue_mrpc_equivalent": ("glue_mrpc_answer", "glue"),
    "glue_mrpc_generate_paraphrase": ("glue_mrpc_generate", "glue"),
    "glue_mrpc_generate_sentence": ("glue_mrpc_generate", "glue"),
    "glue_mrpc_paraphrase": ("glue_mrpc_answer", "glue"),
    "glue_mrpc_replace": ("glue_mrpc_answer", "glue"),
    "glue_mrpc_same_thing": ("glue_mrpc_answer", "glue"),
    "glue_mrpc_want_to_know": ("glue_mrpc_answer", "glue"),
    "imdb_Movie_Expressed_Sentiment": ("imdb_answer", "imdb"),
    "imdb_Movie_Expressed_Sentiment_2": ("imdb_answer", "imdb"),
    "imdb_Negation_template_for_positive_and_negative": ("imdb_not_answer", "imdb"),
    "imdb_Reviewer_Enjoyment": ("imdb_answer", "imdb"),
    "imdb_Reviewer_Enjoyment_Yes_No": ("imdb_answer", "imdb"),
    "imdb_Reviewer_Expressed_Sentiment": ("imdb_answer", "imdb"),
    "imdb_Reviewer_Opinion_bad_good_choices": ("imdb_answer", "imdb"),
    "imdb_Reviewer_Sentiment_Feeling": ("imdb_answer", "imdb"),
    "imdb_Sentiment_with_choices_": ("imdb_answer", "imdb"),
    "imdb_Text_Expressed_Sentiment": ("imdb_answer", "imdb"),
    "imdb_Writer_Expressed_Sentiment": ("imdb_answer", "imdb"),
    "kilt_tasks_hotpotqa_combining_facts": ("kilt_tasks_hotpotqa_answer", "kilt_tasks"),
    "kilt_tasks_hotpotqa_complex_question": ("kilt_tasks_hotpotqa_answer", "kilt_tasks"),
    "kilt_tasks_hotpotqa_final_exam": ("kilt_tasks_hotpotqa_answer", "kilt_tasks"),
    "kilt_tasks_hotpotqa_formulate": ("kilt_tasks_hotpotqa_answer", "kilt_tasks"),
    "kilt_tasks_hotpotqa_straighforward_qa": ("kilt_tasks_hotpotqa_answer", "kilt_tasks"),
    "multi_news_distill": ("multi_news_summary", "multi_news"),
    "multi_news_expand_reverse_task_": ("multi_new_generate", "multi_news"),
    "multi_news_summarize": ("multi_news_summary", "multi_news"),
    "multi_news_summary_scenario": ("multi_news_summary", "multi_news"),
    "multi_news_synthesize": ("multi_news_summary", "multi_news"),
    "multi_news_what_are_the_key_points": ("multi_news_summary", "multi_news"),
    "paws_labeled_final_Concatenation": ("paws_labeled_final_answer", "paws_labeled_final"),
    "paws_labeled_final_Concatenation_no_label": (
        "paws_labeled_final_answer",
        "paws_labeled_final",
    ),
    "paws_labeled_final_Meaning": ("paws_labeled_final_answer", "paws_labeled_final"),
    "paws_labeled_final_Meaning_no_label": ("paws_labeled_final_answer", "paws_labeled_final"),
    "paws_labeled_final_PAWS_ANLI_GPT3": ("paws_labeled_final_answer", "paws_labeled_final"),
    "paws_labeled_final_PAWS_ANLI_GPT3_no_label": (
        "paws_labeled_final_answer",
        "paws_labeled_final",
    ),
    "paws_labeled_final_Rewrite": ("paws_labeled_final_answer", "paws_labeled_final"),
    "paws_labeled_final_Rewrite_no_label": ("paws_labeled_final_answer", "paws_labeled_final"),
    "paws_labeled_final_context_question": ("paws_labeled_final_answer", "paws_labeled_final"),
    "paws_labeled_final_context_question_no_label": (
        "paws_labeled_final_answer",
        "paws_labeled_final",
    ),
    "paws_labeled_final_paraphrase_task": ("paws_labeled_final_generate", "paws_labeled_final"),
    "paws_labeled_final_task_description_no_label": (
        "paws_labeled_final_answer",
        "paws_labeled_final",
    ),
    "qasc_is_correct_1": ("qasc_is_correct", "qasc"),
    "qasc_is_correct_2": ("qasc_is_correct", "qasc"),
    "qasc_qa_with_combined_facts_1": ("qasc_answer", "qasc"),
    "qasc_qa_with_separated_facts_1": ("qasc_answer", "qasc"),
    "qasc_qa_with_separated_facts_2": ("qasc_answer", "qasc"),
    "qasc_qa_with_separated_facts_3": ("qasc_answer", "qasc"),
    "qasc_qa_with_separated_facts_4": ("qasc_answer", "qasc"),
    "qasc_qa_with_separated_facts_5": ("qasc_answer", "qasc"),
    "quail_context_description_question_answer_id": ("quail_answer", "quail"),
    "quail_context_description_question_answer_text": ("quail_answer", "quail"),
    "quail_context_description_question_text": ("quail_answer", "quail"),
    "quail_context_question_answer_description_id": ("quail_answer", "quail"),
    "quail_context_question_answer_description_text": ("quail_answer", "quail"),
    "quail_context_question_description_answer_id": ("quail_answer", "quail"),
    "quail_context_question_description_answer_text": ("quail_answer", "quail"),
    "quail_context_question_description_text": ("quail_answer", "quail"),
    "quail_description_context_question_answer_id": ("quail_answer", "quail"),
    "quail_description_context_question_answer_text": ("quail_answer", "quail"),
    "quail_description_context_question_text": ("quail_answer", "quail"),
    "quail_no_prompt_id": ("quail_answer", "quail"),
    "quail_no_prompt_text": ("quail_answer", "quail"),
    "quarel_choose_between": ("quarel_answer", "quarel"),
    "quarel_do_not_use": ("quarel_answer", "quarel"),
    "quarel_heres_a_story": ("quarel_answer", "quarel"),
    "quarel_logic_test": ("quarel_answer", "quarel"),
    "quarel_testing_students": ("quarel_answer", "quarel"),
    "quartz_answer_question_based_on": ("quartz_answer", "quartz"),
    "quartz_answer_question_below": ("quartz_answer", "quartz"),
    "quartz_given_the_fact_answer_the_q": ("quartz_answer", "quartz"),
    "quartz_having_read_above_passage": ("quartz_answer", "quartz"),
    "quartz_paragraph_question_plain_concat": ("quartz_answer", "quartz"),
    "quartz_read_passage_below_choose": ("quartz_answer", "quartz"),
    "quartz_use_info_from_paragraph_question": ("quartz_answer", "quartz"),
    "quartz_use_info_from_question_paragraph": ("quartz_answer", "quartz"),
    "quoref_Answer_Friend_Question": ("quoref_answer", "quoref"),
    "quoref_Answer_Question_Given_Context": ("quoref_answer", "quoref"),
    "quoref_Answer_Test": ("quoref_answer", "quoref"),
    "quoref_Context_Contains_Answer": ("quoref_answer", "quoref"),
    "quoref_Find_Answer": ("quoref_answer", "quoref"),
    "quoref_Found_Context_Online": ("quoref_answer", "quoref"),
    "quoref_Given_Context_Answer_Question": ("quoref_answer", "quoref"),
    "quoref_Guess_Answer": ("quoref_answer", "quoref"),
    "quoref_Guess_Title_For_Context": ("quoref_generate", "quoref"),
    "quoref_Read_And_Extract_": ("quoref_answer", "quoref"),
    "quoref_What_Is_The_Answer": ("quoref_answer", "quoref"),
    "ropes_background_new_situation_answer": ("ropes_answer", "ropes"),
    "ropes_background_situation_middle": ("ropes_answer", "ropes"),
    "ropes_given_background_situation": ("ropes_answer", "ropes"),
    "ropes_new_situation_background_answer": ("ropes_answer", "ropes"),
    "ropes_plain_background_situation": ("ropes_answer", "ropes"),
    "ropes_plain_bottom_hint": ("ropes_answer", "ropes"),
    "ropes_plain_no_background": ("ropes_answer", "ropes"),
    "ropes_prompt_beginning": ("ropes_answer", "ropes"),
    "ropes_prompt_bottom_hint_beginning": ("ropes_answer", "ropes"),
    "ropes_prompt_bottom_no_hint": ("ropes_answer", "ropes"),
    "ropes_prompt_mix": ("ropes_answer", "ropes"),
    "ropes_read_background_situation": ("ropes_answer", "ropes"),
    "rotten_tomatoes_Movie_Expressed_Sentiment": ("rotten_tomatoes_answer", "rotten_tomatoes"),
    "rotten_tomatoes_Movie_Expressed_Sentiment_2": ("rotten_tomatoes_answer", "rotten_tomatoes"),
    "rotten_tomatoes_Reviewer_Enjoyment": ("rotten_tomatoes_answer", "rotten_tomatoes"),
    "rotten_tomatoes_Reviewer_Enjoyment_Yes_No": ("rotten_tomatoes_answer", "rotten_tomatoes"),
    "rotten_tomatoes_Reviewer_Expressed_Sentiment": ("rotten_tomatoes_answer", "rotten_tomatoes"),
    "rotten_tomatoes_Reviewer_Opinion_bad_good_choices": (
        "rotten_tomatoes_answer",
        "rotten_tomatoes",
    ),
    "rotten_tomatoes_Reviewer_Sentiment_Feeling": ("rotten_tomatoes_answer", "rotten_tomatoes"),
    "rotten_tomatoes_Sentiment_with_choices_": ("rotten_tomatoes_answer", "rotten_tomatoes"),
    "rotten_tomatoes_Text_Expressed_Sentiment": ("rotten_tomatoes_answer", "rotten_tomatoes"),
    "rotten_tomatoes_Writer_Expressed_Sentiment": ("rotten_tomatoes_answer", "rotten_tomatoes"),
    "samsum_Generate_a_summary_for_this_dialogue": ("samsum_summary", "samsum"),
    "samsum_Given_the_above_dialogue_write_a_summary": ("samsum_summary", "samsum"),
    "samsum_Sum_up_the_following_dialogue": ("samsum_summary", "samsum"),
    "samsum_Summarize_this_dialogue_": ("samsum_summary", "samsum"),
    "samsum_Summarize_": ("samsum_summary", "samsum"),
    "samsum_To_sum_up_this_dialog": ("samsum_summary", "samsum"),
    "samsum_Write_a_dialogue_that_match_this_summary": ("samsum_generate", "samsum"),
    "sciq_Direct_Question": ("sciq_answer", "sciq"),
    "sciq_Direct_Question_Closed_Book_": ("sciq_answer", "sciq"),
    "sciq_Multiple_Choice": ("sciq_answer", "sciq"),
    "sciq_Multiple_Choice_Closed_Book_": ("sciq_answer", "sciq"),
    "sciq_Multiple_Choice_Question_First": ("sciq_answer", "sciq"),
    "social_i_qa_Check_if_a_random_answer_is_valid_or_not": ("social_i_qa_valid", "social_i_qa"),
    "social_i_qa_Generate_answer": ("social_i_qa_answer", "social_i_qa"),
    "social_i_qa_Generate_the_question_from_the_answer": ("social_i_qa_generate", "social_i_qa"),
    "social_i_qa_I_was_wondering": ("social_i_qa_answer", "social_i_qa"),
    "social_i_qa_Show_choices_and_generate_answer": ("social_i_qa_answer", "social_i_qa"),
    "social_i_qa_Show_choices_and_generate_index": ("social_i_qa_answer", "social_i_qa"),
    "trec_fine_grained_ABBR": ("trec_answer_fine", "trec"),
    "trec_fine_grained_ABBR_context_first": ("trec_answer_fine", "trec"),
    "trec_fine_grained_DESC": ("trec_answer_fine", "trec"),
    "trec_fine_grained_DESC_context_first": ("trec_answer_fine", "trec"),
    "trec_fine_grained_ENTY": ("trec_answer_fine", "trec"),
    "trec_fine_grained_HUM": ("trec_answer_fine", "trec"),
    "trec_fine_grained_HUM_context_first": ("trec_answer_fine", "trec"),
    "trec_fine_grained_LOC": ("trec_answer_fine", "trec"),
    "trec_fine_grained_LOC_context_first": ("trec_answer_fine", "trec"),
    "trec_fine_grained_NUM": ("trec_answer_fine", "trec"),
    "trec_fine_grained_NUM_context_first": ("trec_answer_fine", "trec"),
    "trec_fine_grained_open": ("trec_answer_fine", "trec"),
    "trec_fine_grained_open_context_first": ("trec_answer_fine", "trec"),
    "trec_pick_the_best_descriptor": ("trec_answer_coarse", "trec"),
    "trec_trec1": ("trec_answer_coarse", "trec"),
    "trec_trec2": ("trec_answer_coarse", "trec"),
    "trec_what_category_best_describe": ("trec_answer_coarse", "trec"),
    "trec_which_category_best_describes": ("trec_answer_coarse", "trec"),
    "wiki_bio_comprehension": ("wiki_bio_details", "wiki_bio"),
    "wiki_bio_guess_person": ("wiki_bio_guess", "wiki_bio"),
    "wiki_bio_key_content": ("wiki_bio_details", "wiki_bio"),
    "wiki_bio_what_content": ("wiki_bio_details", "wiki_bio"),
    "wiki_bio_who": ("wiki_bio_generate", "wiki_bio"),
    "wiki_hop_original_choose_best_object_affirmative_1": ("wiki_hop_answer", "wiki_hop"),
    "wiki_hop_original_choose_best_object_affirmative_2": ("wiki_hop_answer", "wiki_hop"),
    "wiki_hop_original_choose_best_object_affirmative_3": ("wiki_hop_answer", "wiki_hop"),
    "wiki_hop_original_choose_best_object_interrogative_1": ("wiki_hop_answer", "wiki_hop"),
    "wiki_hop_original_choose_best_object_interrogative_2": ("wiki_hop_answer", "wiki_hop"),
    "wiki_hop_original_explain_relation": ("wiki_hop_relation", "wiki_hop"),
    "wiki_hop_original_generate_object": ("wiki_hop_answer", "wiki_hop"),
    "wiki_hop_original_generate_subject": ("wiki_hop_subject", "wiki_hop"),
    "wiki_hop_original_generate_subject_and_object": ("wiki_hop_subject_answer", "wiki_hop"),
    "wiki_qa_Decide_good_answer": ("wiki_qa_valid_answer", "wiki_qa"),
    "wiki_qa_Direct_Answer_to_Question": ("wiki_qa_answer", "wiki_qa"),
    "wiki_qa_Generate_Question_from_Topic": ("wiki_qa_generate", "wiki_qa"),
    "wiki_qa_Is_This_True_": ("wiki_qa_valid_answer", "wiki_qa"),
    "wiki_qa_Jeopardy_style": ("wiki_qa_generate", "wiki_qa"),
    "wiki_qa_Topic_Prediction_Answer_Only": ("wiki_qa_topic", "wiki_qa"),
    "wiki_qa_Topic_Prediction_Question_Only": ("wiki_qa_topic", "wiki_qa"),
    "wiki_qa_Topic_Prediction_Question_and_Answer_Pair": ("wiki_qa_topic", "wiki_qa"),
    "wiki_qa_automatic_system": ("wiki_qa_valid_answer", "wiki_qa"),
    "wiki_qa_exercise": ("wiki_qa_valid_answer", "wiki_qa"),
    "wiki_qa_found_on_google": ("wiki_qa_valid_answer", "wiki_qa"),
    "wiqa_does_the_supposed_perturbation_have_an_effect": ("wiqa_peturbation", "wiqa"),
    "wiqa_effect_with_label_answer": ("wiqa_answer", "wiqa"),
    "wiqa_effect_with_string_answer": ("wiqa_answer", "wiqa"),
    "wiqa_what_is_the_final_step_of_the_following_process": ("wiqa_last_step", "wiqa"),
    "wiqa_what_is_the_missing_first_step": ("wiqa_first_step", "wiqa"),
    "wiqa_what_might_be_the_first_step_of_the_process": ("wiqa_first_step", "wiqa"),
    "wiqa_what_might_be_the_last_step_of_the_process": ("wiqa_last_step", "wiqa"),
    "wiqa_which_of_the_following_is_the_supposed_perturbation": ("wiqa_peturbation_how", "wiqa"),
    "xsum_DOC_boils_down_to_simple_idea_that": ("xsum_summary", "xsum"),
    "xsum_DOC_given_above_write_one_sentence": ("xsum_summary", "xsum"),
    "xsum_DOC_how_would_you_rephrase_few_words": ("xsum_summary", "xsum"),
    "xsum_DOC_tldr": ("xsum_summary", "xsum"),
    "xsum_DOC_write_summary_of_above": ("xsum_summary", "xsum"),
    "xsum_article_DOC_summary": ("xsum_summary", "xsum"),
    "xsum_college_roommate_asked_DOC_so_I_recap": ("xsum_summary", "xsum"),
    "xsum_read_below_DOC_write_abstract": ("xsum_summary", "xsum"),
    "xsum_summarize_DOC": ("xsum_summary", "xsum"),
    "xsum_summarize_this_DOC_summary": ("xsum_summary", "xsum"),
    "yelp_review_full_based_on_that": ("yelp_answer", "yelp_review_full"),
    "yelp_review_full_format_rating": ("yelp_answer", "yelp_review_full"),
    "yelp_review_full_format_score": ("yelp_answer", "yelp_review_full"),
    "yelp_review_full_format_star": ("yelp_answer", "yelp_review_full"),
    "yelp_review_full_on_a_scale": ("yelp_answer", "yelp_review_full"),
    "yelp_review_full_so_i_would": ("yelp_answer", "yelp_review_full"),
    "yelp_review_full_this_place": ("yelp_answer", "yelp_review_full"),
    "anli_GPT_3_style_r1": ("evaluation", "evaluation"),
    "anli_GPT_3_style_r2": ("evaluation", "evaluation"),
    "anli_GPT_3_style_r3": ("evaluation", "evaluation"),
    "anli_MNLI_crowdsource_r1": ("evaluation", "evaluation"),
    "anli_MNLI_crowdsource_r2": ("evaluation", "evaluation"),
    "anli_MNLI_crowdsource_r3": ("evaluation", "evaluation"),
    "anli_always_sometimes_never_r1": ("evaluation", "evaluation"),
    "anli_always_sometimes_never_r2": ("evaluation", "evaluation"),
    "anli_always_sometimes_never_r3": ("evaluation", "evaluation"),
    "anli_based_on_the_previous_passage_r1": ("evaluation", "evaluation"),
    "anli_based_on_the_previous_passage_r2": ("evaluation", "evaluation"),
    "anli_based_on_the_previous_passage_r3": ("evaluation", "evaluation"),
    "anli_can_we_infer_r1": ("evaluation", "evaluation"),
    "anli_can_we_infer_r2": ("evaluation", "evaluation"),
    "anli_can_we_infer_r3": ("evaluation", "evaluation"),
    "anli_claim_true_false_inconclusive_r1": ("evaluation", "evaluation"),
    "anli_claim_true_false_inconclusive_r2": ("evaluation", "evaluation"),
    "anli_claim_true_false_inconclusive_r3": ("evaluation", "evaluation"),
    "anli_consider_always_sometimes_never_r1": ("evaluation", "evaluation"),
    "anli_consider_always_sometimes_never_r2": ("evaluation", "evaluation"),
    "anli_consider_always_sometimes_never_r3": ("evaluation", "evaluation"),
    "anli_does_it_follow_that_r1": ("evaluation", "evaluation"),
    "anli_does_it_follow_that_r2": ("evaluation", "evaluation"),
    "anli_does_it_follow_that_r3": ("evaluation", "evaluation"),
    "anli_does_this_imply_r1": ("evaluation", "evaluation"),
    "anli_does_this_imply_r2": ("evaluation", "evaluation"),
    "anli_does_this_imply_r3": ("evaluation", "evaluation"),
    "anli_guaranteed_possible_impossible_r1": ("evaluation", "evaluation"),
    "anli_guaranteed_possible_impossible_r2": ("evaluation", "evaluation"),
    "anli_guaranteed_possible_impossible_r3": ("evaluation", "evaluation"),
    "anli_guaranteed_true_r1": ("evaluation", "evaluation"),
    "anli_guaranteed_true_r2": ("evaluation", "evaluation"),
    "anli_guaranteed_true_r3": ("evaluation", "evaluation"),
    "anli_justified_in_saying_r1": ("evaluation", "evaluation"),
    "anli_justified_in_saying_r2": ("evaluation", "evaluation"),
    "anli_justified_in_saying_r3": ("evaluation", "evaluation"),
    "anli_must_be_true_r1": ("evaluation", "evaluation"),
    "anli_must_be_true_r2": ("evaluation", "evaluation"),
    "anli_must_be_true_r3": ("evaluation", "evaluation"),
    "anli_should_assume_r1": ("evaluation", "evaluation"),
    "anli_should_assume_r2": ("evaluation", "evaluation"),
    "anli_should_assume_r3": ("evaluation", "evaluation"),
    "anli_take_the_following_as_truth_r1": ("evaluation", "evaluation"),
    "anli_take_the_following_as_truth_r2": ("evaluation", "evaluation"),
    "anli_take_the_following_as_truth_r3": ("evaluation", "evaluation"),
    "hellaswag_Predict_ending_with_hint": ("evaluation", "evaluation"),
    "hellaswag_Randomized_prompts_template": ("evaluation", "evaluation"),
    "hellaswag_complete_first_then": ("evaluation", "evaluation"),
    "hellaswag_if_begins_how_continues": ("evaluation", "evaluation"),
    "super_glue_cb_GPT_3_style": ("evaluation", "evaluation"),
    "super_glue_cb_MNLI_crowdsource": ("evaluation", "evaluation"),
    "super_glue_cb_always_sometimes_never": ("evaluation", "evaluation"),
    "super_glue_cb_based_on_the_previous_passage": ("evaluation", "evaluation"),
    "super_glue_cb_can_we_infer": ("evaluation", "evaluation"),
    "super_glue_cb_claim_true_false_inconclusive": ("evaluation", "evaluation"),
    "super_glue_cb_consider_always_sometimes_never": ("evaluation", "evaluation"),
    "super_glue_cb_does_it_follow_that": ("evaluation", "evaluation"),
    "super_glue_cb_does_this_imply": ("evaluation", "evaluation"),
    "super_glue_cb_guaranteed_possible_impossible": ("evaluation", "evaluation"),
    "super_glue_cb_guaranteed_true": ("evaluation", "evaluation"),
    "super_glue_cb_justified_in_saying": ("evaluation", "evaluation"),
    "super_glue_cb_must_be_true": ("evaluation", "evaluation"),
    "super_glue_cb_should_assume": ("evaluation", "evaluation"),
    "super_glue_cb_take_the_following_as_truth": ("evaluation", "evaluation"),
    "super_glue_copa_C1_or_C2_premise_so_because_": ("evaluation", "evaluation"),
    "super_glue_copa__As_a_result_C1_or_C2_": ("evaluation", "evaluation"),
    "super_glue_copa__What_could_happen_next_C1_or_C2_": ("evaluation", "evaluation"),
    "super_glue_copa__which_may_be_caused_by": ("evaluation", "evaluation"),
    "super_glue_copa__why_C1_or_C2": ("evaluation", "evaluation"),
    "super_glue_copa_best_option": ("evaluation", "evaluation"),
    "super_glue_copa_cause_effect": ("evaluation", "evaluation"),
    "super_glue_copa_choose": ("evaluation", "evaluation"),
    "super_glue_copa_exercise": ("evaluation", "evaluation"),
    "super_glue_copa_i_am_hesitating": ("evaluation", "evaluation"),
    "super_glue_copa_more_likely": ("evaluation", "evaluation"),
    "super_glue_copa_plausible_alternatives": ("evaluation", "evaluation"),
    "super_glue_rte_GPT_3_style": ("evaluation", "evaluation"),
    "super_glue_rte_MNLI_crowdsource": ("evaluation", "evaluation"),
    "super_glue_rte_based_on_the_previous_passage": ("evaluation", "evaluation"),
    "super_glue_rte_can_we_infer": ("evaluation", "evaluation"),
    "super_glue_rte_does_it_follow_that": ("evaluation", "evaluation"),
    "super_glue_rte_does_this_imply": ("evaluation", "evaluation"),
    "super_glue_rte_guaranteed_true": ("evaluation", "evaluation"),
    "super_glue_rte_justified_in_saying": ("evaluation", "evaluation"),
    "super_glue_rte_must_be_true": ("evaluation", "evaluation"),
    "super_glue_rte_should_assume": ("evaluation", "evaluation"),
    "super_glue_wic_GPT_3_prompt": ("evaluation", "evaluation"),
    "super_glue_wic_GPT_3_prompt_with_label": ("evaluation", "evaluation"),
    "super_glue_wic_affirmation_true_or_false": ("evaluation", "evaluation"),
    "super_glue_wic_grammar_homework": ("evaluation", "evaluation"),
    "super_glue_wic_polysemous": ("evaluation", "evaluation"),
    "super_glue_wic_question_context_meaning": ("evaluation", "evaluation"),
    "super_glue_wic_question_context_meaning_with_label": ("evaluation", "evaluation"),
    "super_glue_wic_question_context": ("evaluation", "evaluation"),
    "super_glue_wic_same_sense": ("evaluation", "evaluation"),
    "super_glue_wic_similar_sense": ("evaluation", "evaluation"),
    "super_glue_wsc.fixed_GPT_3_Style": ("evaluation", "evaluation"),
    "super_glue_wsc.fixed_I_think_they_mean": ("evaluation", "evaluation"),
    "super_glue_wsc.fixed_Who_or_what_is_are": ("evaluation", "evaluation"),
    "super_glue_wsc.fixed_by_p_they_mean": ("evaluation", "evaluation"),
    "super_glue_wsc.fixed_does_p_stand_for": ("evaluation", "evaluation"),
    "super_glue_wsc.fixed_does_the_pronoun_refer_to": ("evaluation", "evaluation"),
    "super_glue_wsc.fixed_in_other_words": ("evaluation", "evaluation"),
    "super_glue_wsc.fixed_p_is_are_r": ("evaluation", "evaluation"),
    "super_glue_wsc.fixed_replaced_with": ("evaluation", "evaluation"),
    "super_glue_wsc.fixed_the_pronoun_refers_to": ("evaluation", "evaluation"),
    "winogrande_winogrande_xl_Replace": ("evaluation", "evaluation"),
    "winogrande_winogrande_xl_does_underscore_refer_to": ("evaluation", "evaluation"),
    "winogrande_winogrande_xl_fill_in_the_blank": ("evaluation", "evaluation"),
    "winogrande_winogrande_xl_stand_for": ("evaluation", "evaluation"),
    "winogrande_winogrande_xl_underscore_refer_to": ("evaluation", "evaluation"),
}

# these dictionaries may be useful, so we define them here

TASK_TO_PROMPTS: Dict[str, List[str]] = {}
for k, v in PROMPT_MAPPING.items():
    if v[0] not in TASK_TO_PROMPTS:
        TASK_TO_PROMPTS[v[0]] = []
    TASK_TO_PROMPTS[v[0]].append(k)

DATASET_TO_PROMPTS: Dict[str, List[str]] = {}
for k, v in PROMPT_MAPPING.items():
    if v[1] not in DATASET_TO_PROMPTS:
        DATASET_TO_PROMPTS[v[1]] = []
    DATASET_TO_PROMPTS[v[1]].append(k)

BBH_SUBSETS = [
    "boolean_expressions",
    "causal_judgement",
    "date_understanding",
    "disambiguation_qa",
    "dyck_languages",
    "formal_fallacies",
    "geometric_shapes",
    "hyperbaton",
    "logical_deduction_five_objects",
    "logical_deduction_seven_objects",
    "logical_deduction_three_objects",
    "movie_recommendation",
    "multistep_arithmetic_two",
    "navigate",
    "object_counting",
    "penguins_in_a_table",
    "reasoning_about_colored_objects",
    "ruin_names",
    "salient_translation_error_detection",
    "snarks",
    "sports_understanding",
    "temporal_sequences",
    "tracking_shuffled_objects_five_objects",
    "tracking_shuffled_objects_seven_objects",
    "tracking_shuffled_objects_three_objects",
    "web_of_lies",
    "word_sorting",
]
