import argparse
import os

parser = argparse.ArgumentParser()
parser.add_argument("--index_path", type=str)
parser.add_argument("--num_clusters", type=int)
parser.add_argument("--clustering_metric", type=str)
parser.add_argument("--output_file", type=str, default=None)
args = parser.parse_args()

if os.path.exists(args.output_file):
    print(f'File {args.output_file} already exists. Skipping...')
    exit(0)


assert args.index_path is not None and os.path.exists(args.index_path)

from infdist.utils import Clusters, Embeddings
embeddings = Embeddings(
    args.index_path,
    None,
    None,
    None,
    seq_len=None
)

clusters = Clusters(
    args.output_file,
    embeddings,
    num_clusters=args.num_clusters,
    metric=args.clustering_metric,
    method='kmeans_kmedoids',

    # samples with no lable cannot be cluster centers
    skip_as_center=None
)

clusters.get()