## Defective Convolutional Networks
## Requirements
- Python: 2.7.14
- PyTorch: 0.4.1
- CUDA: 9.0

## Codes Organization

- Attacks: implementations of attack methods including FGSM, PGD, MIFGSM, CW, and boundray attacks. The codes will generate adversarial examples, and test the white-box defense performance (FGSM, PGD, MIFGSM, CW), and the black-box defense performance against decision-based attack. Also, we have compared our implementations with the implementation from Github.

- Defenses: codes to evaluate the black-box defense performance against the adversarial examples generated by other models. Using the implementations under **Attacks** folder to generate adversarial examples. Running the codes under **Mains** folder to train the models.

- Mains: codes for training models on CIFAR-10 dataset. codes are named as main_xxx_drop_ttt_pp.py, where xxx means the network archtecture or used methods, ttt means the position to apply defective convolutional layers, and pp means the (1 - keep probability). If xxx is omitted, the code train a model based on ResNet-18.

- Masks: codes for generating masks of defective neurons. codes are named as genmask_xxx_ttt_pp.py, where xxx means the network archtecture, ttt means the position to apply defective convolutional layers, and pp means the (1 - keep probability). If xxx is omitted, the code generates a mask for ResNet-18.

- MNIST: codes for MNIST experiments. See the paper for detailed settings.

- Models: various networks including all standard CNNs and their defective version. codes are named as xxx_drop_ttt_pp.py, where xxx means the network archtecture, ttt means the position to apply defective convolutional layers, and pp means the (1 - keep probability).

- RandomShuffle: codes for the random shuffle experiments. See the paper for detailed settings.

- RandomNoise: codes for the random noise experiments. See the paper for detailed settings.

- Stylized-ImageNet: codes for Stylized-ImageNet experiments in Section 3.2.
