import openai
from task import Task
import time
from random import randrange


def read_api_key(gpt_version="3.5"):
    version_map = {"3.5":"api_key_project.txt","4":"api_key.txt"}
    with open(version_map[gpt_version], "r") as f:
        return f.read()


if __name__ == "__main__":

    #gpt_version = "3.5"
    gpt_version = "4"
    
    #task_type="2d"
    task_type="1d"

    api_key = read_api_key(gpt_version=gpt_version)
    print(api_key)
    openai.api_key = api_key.rstrip()


    custom_list = [40,43,44,45,47,48,49]
    #for i in range(19,50):
    #for i in custom_list:
    for i in range(50):
        print(str(i)+".json")
        #task = Task(filepath="dataset/1d_tasks/basic_fill/bfill_"+str(i)+".json", db_path="results/1d_bfill_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/basic_move/bmove_"+str(i)+".json", db_path="results/1d_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/fill_n_move/fmove_"+str(i)+".json", db_path="results/1d_fmove_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/2d_fill/2dfill_"+str(i)+".json", db_path="results/1d_2dfill_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/2d1d_fill/2d1dfill_"+str(i)+".json", db_path="results/1d_2d1dfill_solutions.csv")

        # 1d arcfills,trimed
        #task = Task(filepath="dataset/1d_tasks/arcfill_1d_single_trim/arc1st_"+str(i)+".json", db_path="results/1d_arc1st_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/arcfill_1d_mult_trim/arc1mt_"+str(i)+".json", db_path="results/1d_arc1mt_solutions.csv")

        # 1d arcfills,with padding
        #task = Task(filepath="dataset/1d_tasks/arcfill_1d_single/arc1s_"+str(i)+".json", db_path="results/1d_arc1s_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/arcfill_1d_mult/arc1m_"+str(i)+".json", db_path="results/1d_arc1m_solutions.csv")

        # 2d arcfills
        # 2d basics, wrapping blank rows
        #task = Task(filepath="dataset/1d_tasks/arcfill_2d_single_basic/arc2s_"+str(i)+".json", db_path="results/1d_arc2s_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/arcfill_2d_mult_basic/arc2m_"+str(i)+".json", db_path="results/1d_arc2m_solutions.csv")

        #task = Task(filepath="dataset/1d_tasks/arcfill_2d_single_mrows/arc2smr_"+str(i)+".json", db_path="results/1d_arc2smr_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/arcfill_2d_mult_mrows/arc2mmr_"+str(i)+".json", db_path="results/1d_arc2mmr_solutions.csv")

        #task = Task(filepath="dataset/1d_tasks/arcfill_2d_single_mrows_crop/arc2smrc_"+str(i)+".json", db_path="results/1d_arc2smrc_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/arcfill_2d_mult_mrows_crop/arc2mmrc_"+str(i)+".json", db_path="results/1d_arc2mmrc_solutions.csv")

        #task = Task(filepath="dataset/1d_tasks/arcfill_1d_single_trim_v/arc1st_v_"+str(i)+".json", db_path="results/1d_arc1st_v_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/arcfill_1d_mult_trim_v/arc1mt_v_"+str(i)+".json", db_path="results/1d_arc1mt_v_solutions.csv")

        #task = Task(filepath="dataset/1d_tasks/arcfill_1d_single_v/arc1s_v_"+str(i)+".json", db_path="results/1d_arc1s_v_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/arcfill_1d_mult_v/arc1m_v_"+str(i)+".json", db_path="results/1d_arc1m_v_solutions.csv")

        #task = Task(filepath="dataset/1d_tasks/arcfill_2d_single_mrows_v/arc2smr_v_"+str(i)+".json", db_path="results/1d_arc2smr_v_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/arcfill_2d_mult_mrows_v/arc2mmr_v_"+str(i)+".json", db_path="results/1d_arc2mmr_v_solutions.csv")

        #task = Task(filepath="dataset/1d_tasks/arcfill_2d_single_mrows_crop_v/arc2smrc_v_"+str(i)+".json", db_path="results/1d_arc2smrc_v_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/arcfill_2d_mult_mrows_crop_v/arc2mmrc_v_"+str(i)+".json", db_path="results/1d_arc2mmrc_v_solutions.csv")

        #task = Task(filepath="dataset/1d_tasks/arcfill_2d_single_basic_v/arc2s_v_"+str(i)+".json", db_path="results/1d_arc2s_v_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/arcfill_2d_mult_basic_v/arc2m_v_"+str(i)+".json", db_path="results/1d_arc2m_v_solutions.csv")

        # Reverse versions
        #task = Task(filepath="dataset/1d_tasks/basic_fill_reverse/bfill_r_"+str(i)+".json", db_path="results/1d_bfill_r_solutions.csv")

        # Extends
        #task = Task(filepath="dataset/1d_tasks/basic_fill_3/bfill_3_"+str(i)+".json", db_path="results/1d_bfill_3_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/basic_fill_3_m/bfill_3m_"+str(i)+".json", db_path="results/1d_bfill_3_m_solutions.csv")

        #task = Task(filepath="dataset/1d_tasks/basic_fill_3_l/bfill_3l_"+str(i)+".json", db_path="results/1d_bfill_3_l_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/basic_fill_3_r/bfill_3r_"+str(i)+".json", db_path="results/1d_bfill_3_r_solutions.csv")
        task = Task(filepath="dataset/1d_tasks/basic_fill_3_f/bfill_3f_"+str(i)+".json", db_path="results/1d_bfill_3_f_solutions.csv")

        # 1D flip
        #task = Task(filepath="dataset/1d_tasks/1d_flip_single/1dflip_s_"+str(i)+".json", db_path="results/1d_flip_single_solutions.csv")

        # 1D mirroring
        #task = Task(filepath="dataset/1d_tasks/1d_mirror_single/1dmirror_s_"+str(i)+".json", db_path="results/1d_mirror_single_solutions.csv")

        # 1D denoising
        #task = Task(filepath="dataset/1d_tasks/1d_1c_denoising_single/1d1cdenoi_s_"+str(i)+".json", db_path="results/1d_1c_denoising_single_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/1d_mc_denoising_single/1dmcdenoi_s_"+str(i)+".json", db_path="results/1d_mc_denoising_single_solutions.csv")

        # 1D basic moves
        # 1 pixel right
        #task = Task(filepath="dataset/1d_tasks/basic_move_1/bmove_1p_"+str(i)+".json", db_path="results/1d_bmove_1_solutions.csv")
        # 2 pixels right
        #task = Task(filepath="dataset/1d_tasks/basic_move_2/bmove_2p_"+str(i)+".json", db_path="results/1d_bmove_2_solutions.csv")

        #task = Task(filepath="dataset/1d_tasks/basic_move_2p_p/bmove_2p_p_"+str(i)+".json", db_path="results/1d_bmove_2_p_solutions.csv")

        # dynamic pixels
        #task = Task(filepath="dataset/1d_tasks/basic_move_dp/bmove_dp_"+str(i)+".json", db_path="results/1d_bmove_dp_solutions.csv")

        # Pattern copy
        #task = Task(filepath="dataset/1d_tasks/1d_pcopy_1c/1dpcopy_1c_"+str(i)+".json", db_path="results/1d_pcopy_1c_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/1d_pcopy_mc/1dpcopy_mc_"+str(i)+".json", db_path="results/1d_pcopy_mc_solutions.csv")

        # Recolors
        #task = Task(filepath="dataset/1d_tasks/1d_recolor_oe/1drec_oe_"+str(i)+".json", db_path="results/1d_recolor_oe_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/1d_recolor_cnt/1drec_cnt_"+str(i)+".json", db_path="results/1d_recolor_cnt_solutions.csv")
        #task = Task(filepath="dataset/1d_tasks/1d_recolor_cmp/1drec_cmp_"+str(i)+".json", db_path="results/1d_recolor_cmp_solutions.csv")

        # 1D scale
        #task = Task(filepath="dataset/1d_tasks/1d_scale_dp/1dscale_dp_"+str(i)+".json", db_path="results/1d_scale_dp_solutions.csv")

        # LEVEL-2s
        #task = Task(filepath="dataset/1d_tasks/1d_move_1p_recolor/1dm1p_rec_"+str(i)+".json", db_path="results/1d_move_1p_recolor_solutions.csv")

        # Best performance on ARC-simple-50 is 5/50, word+pipe
        task.run_GPT(mode="grid", encoding="word", delimiter="|", json_str="", gpt=gpt_version, task_type=task_type)

        #time.sleep(randrange(2,4))

        #break

    print(gpt_version,task_type,task.db_path)

