import os
import sys

import seaborn as sns

from godin.threshold import find_threshold_ind_data
from godin.utils_godin import show_stats

sys.path.insert(1, os.path.dirname(os.getcwd()))
sns.set(font_scale=1.0, style='whitegrid', rc={"grid.linewidth": 1.})

sns.set_palette("colorblind")
import numpy as np
import matplotlib.pyplot as plt
import pandas as pd

palette = sns.color_palette('colorblind')


def plot_scores_for_godin():
    data_ind = 'CIFAR10'
    data_ood = 'SVHN'
    # data_type = 'id_test'
    # data_type = 'ood_test'
    data_type = 'id_train'
    percentile_threshold = ''
    # percentile_threshold = '_threshold_0.01'
    name = f'{data_type}_results_ind_{data_ind}_ood_{data_ood}{percentile_threshold}'
    outputs = 'outputs'
    scores = np.load(os.path.join(outputs, name + '.npy'))

    scores = np.sort(scores)
    show_stats(data=scores)

    threshold = find_threshold_ind_data(ind_test_scores=scores,
                                        percentile=0.01)
    print('threshold: ', threshold)

    print('data type: ', data_type)

    data = pd.DataFrame({
        'score index': [x for x in range(len(scores))],
        'sorted score values': scores,
    })

    sns.lineplot(data=data, x='score index', y='sorted score values')
    plt.title(f'Sorted score values for {data_type} data. '
              f'Data ind: {data_ind}. Data ood: {data_ood}.')
    # loc = 'best'
    # plt.legend(loc=loc)
    plt.tight_layout()
    # plt.xlim((0, 50))
    dest = os.path.join('plots', name + '.pdf')
    plt.savefig(dest, bbox_inches='tight', pad_inches=0.05)


if __name__ == "__main__":
    plot_scores_for_godin()
