import Mathlib.Tactic.Common

open Lean Core Elab IO Meta Term Tactic

def isInstProp (expr : Expr) : MetaM Bool := do
  let ty ← instantiateMVars (← inferType expr)
  return ty.isProp

elab "dropHyp" name:(ident)? idx:(num)? : tactic => do
  let goal ← getMainGoal
  let goalType ← goal.getType
  let (premises, binders, conclusion) ← forallMetaTelescope goalType
  let mut vars := #[]
  let mut hyps := #[]
  for i in [0:premises.size] do
    let premise := premises[i]!
    let binder := binders[i]!
    let ty ← instantiateMVars (← inferType premise)
    let isVariable := binder.isImplicit || binder.isInstImplicit || !(← isInstProp ty)
    -- let isHypothesis := (← Meta.isProp ty) && (!isVariable)
    -- logInfo m!"Premise {i}: ty: {←ppExpr ty} | IsVariable: {isVariable} | IsHypothesis: {isHypothesis}"
    if isVariable then
      vars := vars.push premise
    else
      hyps := hyps.push premise
  -- IO.println s!"vars: {vars.size} hyps: {hyps.size}"
  if premises.isEmpty then
    logInfo "No premises to drop!"
  else
    let name : Name ← match name with
      | some name => pure name.getId
      | none => mkAuxName ((← getCurrNamespace) ++ `extracted) 1
    -- let index ← IO.rand 0 (hyps.size - 1)
    let index ← match idx with
      | some idx =>
        let i := idx.getNat
        if i >= hyps.size then
          throwError "Index out of bounds. There are only {hyps.size} droppable premises."
        pure i
      | none => IO.rand 0 (hyps.size - 1)
    let mut newConclusion := conclusion
    for i in (List.range hyps.size).reverse do
      if i ≠ index then
        newConclusion ← mkArrow (← inferType hyps[i]!) newConclusion
    let droppedHyp ← mkForallFVars vars (← instantiateMVars (← inferType hyps[index]!))
    let NotdroppedHyp ← mkAppM ``Not #[droppedHyp]
    IO.println s!"dropped_hypothesis_{index}: theorem {name}_hyp : {←ppExpr NotdroppedHyp} := sorry"
    let newGoalTy ← mkForallFVars vars newConclusion
    let NotnewGoalTy ← mkAppM ``Not #[newGoalTy]
    IO.println s!"mutated_version_{index}: theorem {name} : {←ppExpr NotnewGoalTy} := sorry"
    -- let newGoal ← mkFreshExprMVar NotnewGoalTy
    -- goal.assign (← mkSorry goalType false)
    -- replaceMainGoal [newGoal.mvarId!]


syntax (name := replShowHyps) "replShowHyps" : tactic

@[tactic replShowHyps] def evalReplShowHyps : Tactic := fun _ => do
  let hyps ← getLCtx
  for decl in hyps do
    if !decl.isImplementationDetail then
      if (← isProp decl.type) then
        logInfo m!"{decl.userName} : {decl.type}"
  pure ()

/-
replDropHyp tries to drop a hypothesis from the context.
It first tries to find the hypothesis with the given index.
If it fails, it tries to drop a random hypothesis.
It then extracts the goal and drops the hypothesis from the context.
It then returns the extracted goal.
-/
syntax (name := replDropHyp) "replDropHyp " ident num : tactic

@[tactic replDropHyp]
def evalReplDropHyp : Tactic := fun stx => match stx with
  | `(tactic| replDropHyp $name:ident $hidx:num) => do
    let name ← match name with
      | `(ident| $name:ident) => pure name.getId
      | _ => mkAuxName ((← getCurrNamespace) ++ `extracted) 1
    let hidx := hidx.getNat
    let ctx ← getLCtx
    let mut unusedHyps := #[]
    let mut hyps := #[]
    let mut vars := #[]
    for decl in ctx do
      if name.toString = decl.userName.toString then -- skip the theorem
        continue
      else if decl.userName.toString.startsWith "x._@" then -- redudant
        unusedHyps := unusedHyps.push decl.fvarId
      else if !decl.isImplementationDetail ∧ (← isProp decl.type) then
        hyps := hyps.push decl.fvarId
      else
        vars := vars.push decl.fvarId
    unusedHyps := unusedHyps.push hyps[hidx]!
    let newVars := vars.map mkFVar
    let newHyp := mkFVar hyps[hidx]!
    let (premises, _, conclusion) ← forallMetaTelescope
        (← mkForallFVars newVars (← instantiateMVars (← inferType newHyp)))
    let droppedHyp ← mkForallFVars premises conclusion
    let NotdroppedHyp ← mkAppM ``Not #[droppedHyp]
    let name := name.appendAfter s!"_drop{hidx}"
    let full_name := name.appendBefore s!"full"
    logInfo m!"dropped_hypothesis_{hidx}: theorem {name}_hyp : {← ppExpr NotdroppedHyp} := sorry"
    let tyPP ← withOptions (fun opts => opts.setBool `pp.all true) <| ppExpr NotdroppedHyp
    logInfo m!"full_dropped_hypothesis_{hidx}: theorem {full_name}_hyp : {tyPP} := sorry"

    liftMetaTactic fun mvarId => do
      let mvarId ← mvarId.tryClearMany unusedHyps
      return [mvarId]
  | _ => throwUnsupportedSyntax

elab "replExtractGoal" name:(ident) hidx:(num) : tactic => do
  let name ← match name with
    | `(ident| $name:ident) => pure name.getId
    | _ => mkAuxName ((← getCurrNamespace) ++ `extracted) 1
  let hidx := hidx.getNat
  let (msg1, msg2) ← withoutModifyingEnv <| withoutModifyingState do
    let g ← getMainGoal
    let (g, _) ← g.renameInaccessibleFVars
    let (_, g) ← g.revert (clearAuxDeclsInsteadOfRevert := true) (← g.getDecl).lctx.getFVarIds
    let ty ← instantiateMVars (← g.getType)
    if ty.hasExprMVar then
      -- TODO: turn metavariables into new hypotheses?
      throwError "Extracted goal has metavariables: {ty}"
    let ty ← Term.levelMVarToParam ty
    let ty ← mkAppM ``Not #[ty]
    -- logInfo m!"ty: {ty}"
    let cmd := if ← Meta.isProp ty then "theorem" else "def"
    let name := name.appendAfter s!"_drop{hidx}"
    let full_name := name.appendBefore s!"full_"
    let msg1 := m!"mutated_version_{hidx}: {cmd} {name} : {ty} := sorry"
    let tyPP ← withOptions (fun opts => opts.setBool `pp.all true) <| ppExpr ty  -- use ppExpr and apply pp.all
    let msg2 := m!"full_mutated_version_{hidx}: {cmd} {full_name} : {tyPP} := sorry"
    pure (msg1, msg2)
  logInfo msg1
  logInfo msg2

elab "replMutation" idx:(num) : tactic => do
  let some name ← getDeclName? | throwError "Not in a theorem context"
  Tactic.evalTactic (← `(tactic| (replDropHyp $(mkIdent name) $idx);
                                 (replExtractGoal $(mkIdent name) $idx);
                                 ))


elab "disProve" name:(ident) : tactic => do
  let name ← match name with
    | `(ident| $name:ident) => pure name.getId
    | _ => mkAuxName ((← getCurrNamespace) ++ `extracted) 1
  let (msg1, msg2) ← withoutModifyingEnv <| withoutModifyingState do
    let g ← getMainGoal
    let (g, _) ← g.renameInaccessibleFVars
    let (_, g) ← g.revert (clearAuxDeclsInsteadOfRevert := true) (← g.getDecl).lctx.getFVarIds
    let ty ← instantiateMVars (← g.getType)
    if ty.hasExprMVar then
      -- TODO: turn metavariables into new hypotheses?
      throwError "Extracted goal has metavariables: {ty}"
    let ty ← Term.levelMVarToParam ty
    let ty ← mkAppM ``Not #[ty]
    -- logInfo m!"ty: {ty}"
    let cmd := if ← Meta.isProp ty then "theorem" else "def"
    let name := name.appendAfter s!"_disprove"
    let full_name := name.appendBefore s!"full_"
    let msg1 := m!"disprove_version: {cmd} {name} : {ty} := sorry"
    let tyPP ← withOptions (fun opts => opts.setBool `pp.all true) <| ppExpr ty  -- use ppExpr and apply pp.all
    let msg2 := m!"full_disprove_version_disprove: {cmd} {full_name} : {tyPP} := sorry"
    pure (msg1, msg2)
  logInfo msg1
  logInfo msg2


-- example : ∀ {a b c : ℕ}, a = b → b = c → a = 0 → a = c := by
  -- drop_random_premise
  -- dropHyp 2  -- 可能变成 ∀ {a b c : ℕ}, a = b → a = c
  -- extractGoal

-- example (a b c : ℕ) (h1 : a = b) (h2 : b = c) (h3 : a = 0): a = c := by
  -- drop_random_premise
  -- dropHyp 0  -- 可能变成 ∀ {a b c : ℕ}, a = b → a = c
  -- replMutation 0
  -- replDropHyp h2 1
  -- replExtractGoal h3 2
  -- simp
