import Mutation.HypDrop
import Mutation.StyConv

import Mathlib
import Aesop

set_option maxHeartbeats 0
set_option maxRecDepth 1000
set_option tactic.hygienic false

open BigOperators Real Nat Topology Rat

lemma round3_sum_val_at_7_43 :
  (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (7.43 + (k : ℝ) / 100)) = 546 := by
  norm_num [Finset.sum_Icc_succ_top]

lemma round3_sum_val_at_7_44 :
  (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (7.44 + (k : ℝ) / 100)) = 547 := by
  norm_num [Finset.sum_Icc_succ_top]

lemma round4_r_lt_7_44 (r : ℝ) (h₀ : (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (r + k / 100)) = 546) : r < 7.44 := by
  by_contra h
  have h₁ : r ≥ 7.44 := by linarith
  have h₂ : ∀ k : ℕ, k ∈ Finset.Icc (19 : ℕ) 91 → (r + (k : ℝ) / 100) ≥ (7.44 + (k : ℝ) / 100) := by
    intro k _
    linarith
  have h₃ : ∀ k : ℕ, k ∈ Finset.Icc (19 : ℕ) 91 → Int.floor (r + (k : ℝ) / 100) ≥ Int.floor (7.44 + (k : ℝ) / 100) := by
    intro k hk
    have h₄ : (r + (k : ℝ) / 100) ≥ (7.44 + (k : ℝ) / 100) := h₂ k hk
    exact Int.floor_mono h₄
  have h₄ : (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (r + (k : ℝ) / 100)) ≥ (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (7.44 + (k : ℝ) / 100)) := by
    apply Finset.sum_le_sum
    intro k hk
    exact h₃ k hk
  have h₅ : (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (r + (k : ℝ) / 100)) = 546 := h₀
  have h₆ : (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (7.44 + (k : ℝ) / 100)) = 547 := round3_sum_val_at_7_44
  to_theorem (rw [h₅, h₆] at h₄)
  linarith


lemma round4_r_ge_7_43 (r : ℝ) (h₀ : (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (r + k / 100)) = 546) : 7.43 ≤ r := by
  by_contra h
  have_with_extraction h₁ : r < 7.43 := by linarith
  have h₂ : ∀ k : ℕ, k ∈ Finset.Icc (19 : ℕ) 91 → (r + (k : ℝ) / 100) < (7.43 + (k : ℝ) / 100) := by
    intro k _
    linarith
  have h₃ : ∀ k : ℕ, k ∈ Finset.Icc (19 : ℕ) 91 → Int.floor (r + (k : ℝ) / 100) ≤ Int.floor (7.43 + (k : ℝ) / 100) := by
    intro k hk
    have h₄ : (r + (k : ℝ) / 100) ≤ (7.43 + (k : ℝ) / 100) := by linarith [h₂ k hk]
    exact Int.floor_mono h₄
  have h_k57_in_Icc : (57 : ℕ) ∈ Finset.Icc (19 : ℕ) 91 := by
    simp
  have h_k57_term_r : Int.floor (r + (57 : ℝ) / 100) ≤ 7 := by
    by_contra h_contra
    have h_contra' : Int.floor (r + (57 : ℝ) / 100) > 7 := by linarith
    have h_contra'' : Int.floor (r + (57 : ℝ) / 100) ≥ 8 := by linarith
    have h_floor_ge : r + (57 : ℝ) / 100 ≥ (8 : ℝ) := by
      have h : (8 : ℝ) ≤ (Int.floor (r + (57 : ℝ) / 100) : ℝ) := by exact_mod_cast h_contra''
      have h'' : (Int.floor (r + (57 : ℝ) / 100) : ℝ) ≤ r + (57 : ℝ) / 100 := Int.floor_le (r + (57 : ℝ) / 100)
      linarith
    have h_r_plus_57_lt_8 : r + (57 : ℝ) / 100 < 8 := by linarith
    linarith
  have h_k57_term_743 : Int.floor (7.43 + (57 : ℝ) / 100) = 8 := by
    norm_num
  have h_strict_k57 : Int.floor (r + (57 : ℝ) / 100) < Int.floor (7.43 + (57 : ℝ) / 100) := by
    linarith [h_k57_term_r, h_k57_term_743]
  have h_sum_le : (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (r + (k : ℝ) / 100)) ≤ (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (7.43 + (k : ℝ) / 100)) := by
    -- to_theorem (apply Finset.sum_le_sum)
    apply_with_extraction 1 Finset.sum_le_sum
    intro k hk
    exact h₃ k hk
  have h_nonempty : (Finset.Icc (19 : ℕ) 91).Nonempty := by
    exact ⟨19, by simp⟩
  have h_exists_lt : ∃ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (r + (k : ℝ) / 100) < Int.floor (7.43 + (k : ℝ) / 100) := by
    refine' ⟨57, h_k57_in_Icc, _⟩
    exact h_strict_k57
  have h_sum_lt : (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (r + (k : ℝ) / 100)) < (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (7.43 + (k : ℝ) / 100)) := by
    apply Finset.sum_lt_sum
    · intro k _
      exact h₃ k ‹_›
    · exact h_exists_lt
  have h_sum_val_743 : (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (7.43 + (k : ℝ) / 100)) = 546 := round3_sum_val_at_7_43
  have h_sum_val_r : (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (r + (k : ℝ) / 100)) = 546 := h₀
  rw [h_sum_val_r, h_sum_val_743] at h_sum_lt
  linarith

theorem aime_1991_p6 (r : ℝ) (h₀ : (∑ k ∈ Finset.Icc (19 : ℕ) 91, Int.floor (r + k / 100)) = 546) :
    Int.floor (100 * r) = 743 := by
  have h_lt_7_44 : r < 7.44 := round4_r_lt_7_44 r h₀
  have h_ge_7_43 : 7.43 ≤ r := round4_r_ge_7_43 r h₀
  have h1 : 7.43 ≤ r := h_ge_7_43
  have h2 : r < 7.44 := h_lt_7_44
  have h3 : 743 ≤ 100 * r := by linarith
  have h4 : 100 * r < 744 := by linarith
  have h5 : Int.floor (100 * r) = 743 := by
    rw [Int.floor_eq_iff]
    norm_num
    constructor <;> linarith
  exact h5

#print axioms aime_1991_p6


theorem extracted_formal_statement (r : ℝ) (h₀ : ∑ k ∈ Finset.Icc (19:ℕ) 91, ⌊r + ↑k / 100⌋ = 546) (h_1 : ¬7.43 ≤ r)
  (h₁ : r < 7.43) (h₂ : ∀ k ∈ Finset.Icc (19:ℕ) 91, r + ↑k / 100 < 7.43 + ↑k / 100)
  (h₃ : ∀ k ∈ Finset.Icc (19:ℕ) 91, ⌊r + ↑k / 100⌋ ≤ ⌊(7.43 : ℝ) + ↑k / 100⌋) (h_k57_term_r : ⌊r + 57 / 100⌋ ≤ 7)
  (h_strict_k57 : ⌊r + 57 / 100⌋ < ⌊(7.43 : ℝ) + 57 / 100⌋) (h : ∀ i ∈ Finset.Icc (19:ℕ) 91, ⌊r + ↑i / 100⌋ ≤ ⌊(7.43 : ℝ) + ↑i / 100⌋) :
  ∑ k ∈ Finset.Icc (19:ℕ) 91, ⌊r + ↑k / 100⌋ ≤ ∑ k ∈ Finset.Icc (19:ℕ) 91, ⌊(7.43 : ℝ) + ↑k / 100⌋ := by
  apply Finset.sum_le_sum
  assumption

theorem extracted_formal_statement1 (r : ℝ) (h₀ : ∑ k ∈ Finset.Icc (19:ℕ) 91, ⌊r + ↑k / 100⌋ = 546) (h_1 : ¬7.43 ≤ r)
  (h₁ : r < 7.43) (h₂ : ∀ k ∈ Finset.Icc (19:ℕ) 91, r + ↑k / 100 < 7.43 + ↑k / 100)
  (h₃ : ∀ k ∈ Finset.Icc (19:ℕ) 91, ⌊r + ↑k / 100⌋ ≤ ⌊(7.43 : ℝ) + ↑k / 100⌋) (h_k57_term_r : ⌊r + 57 / 100⌋ ≤ 7)
  (h_strict_k57 : ⌊r + 57 / 100⌋ < ⌊(7.43 : ℝ) + 57 / 100⌋) (h : ∀ i ∈ Finset.Icc (19:ℕ) 91, ⌊r + ↑i / 100⌋ ≤ ⌊(7.43 : ℝ) + ↑i / 100⌋) :
  ∑ k ∈ Finset.Icc (19:ℕ) 91, ⌊r + ↑k / 100⌋ ≤ ∑ k ∈ Finset.Icc (19:ℕ) 91, ⌊(7.43 : ℝ) + ↑k / 100⌋ := by
  -- replExtractGoal drop_test 2
  replMutation 2
  apply Finset.sum_le_sum
  assumption
