#!/bin/bash
# -----------------------------------------------------------------------------
# This is a Bash script to run the Lean mutateion with proof-style conversion as augmentation pipeline.
#
# Workflow:
#   1. Proof-style conversion (style_convert.py): convert the style of the theorems.
#   2. Fix unused variables (fix_unused.py): fix unused variables in the theorems.
#   3. Mutate the theorems (mutate_jsonfile.py): mutate the theorems.

#
# Usage:
#   1. Set all paths and parameters in the "CONFIGURATION" section.
#   2. Run from the terminal: bash aug_mutate_jsonfile.sh
# -----------------------------------------------------------------------------

set -e

# --- CONFIGURATION ---
# =============================================================================
# *** MODIFY YOUR SETTINGS HERE ***
INPUT_PATH="datasets/extracted/minif2f_theorems.json"
OUTPUT_PATH="datasets/save/aug_minif2f_theorems.json"
NUM_THEOREMS=-1
BATCH_SIZE=20000
# =============================================================================

# parse the input file

# Extract filename without extension
FILENAME=$(basename "$INPUT_PATH" .json)

CONVETED_FILE_PATH="datasets/tmp/${FILENAME}_converted.json"
FIX_CONVETED_FILE_PATH="datasets/tmp/${FILENAME}_fixed_converted.json"

mkdir -p logs
mkdir -p datasets/tmp/

# echo "Converting style of the theorems..."
python src/style_convert.py --input_file $INPUT_PATH --output_file $CONVETED_FILE_PATH --num_theorems $NUM_THEOREMS --batch_size $BATCH_SIZE

# echo "Fixing unused variables in the theorems..."
python src/fix_unused.py --input_file $CONVETED_FILE_PATH --output_file $FIX_CONVETED_FILE_PATH --num_theorems $NUM_THEOREMS --batch_size $BATCH_SIZE

echo "Mutating the theorems..."
python src/mutate_jsonfile.py --input_file $FIX_CONVETED_FILE_PATH --output_file $OUTPUT_PATH --num_theorems $NUM_THEOREMS --batch_size $BATCH_SIZE

rm -rf datasets/tmp/
echo "Done!"