#!/bin/bash
# -----------------------------------------------------------------------------
# This is a Bash script to run the Lean style conversion pipeline.
#
# Workflow:
#   1. Data extraction (extract.py): extract all theorems from the input file (including imports).
#   2. Style conversion (style_convert.py): convert the style of the theorems.
#
# Usage:
#   1. Set all paths and parameters in the "CONFIGURATION" section.
#   2. Run from the terminal: bash convert_style.sh
# -----------------------------------------------------------------------------

set -e

# --- CONFIGURATION ---
# =============================================================================
# *** MODIFY YOUR SETTINGS HERE ***
INPUT_PATH="datasets/total_theorems.json"
OUTPUT_PATH="datasets/tmp/converted_total_theorems.json"
# =============================================================================

python src/style_convert.py --input_file $INPUT_PATH --output_file $OUTPUT_PATH