#!/bin/bash
# -----------------------------------------------------------------------------
# This is a Bash script to run the Lean unused variable fix pipeline.
#
# Workflow:
#   1. Fix unused variables (fix_unused.py): fix unused variables in the theorems.
#
# Usage:
#   1. Set all paths and parameters in the "CONFIGURATION" section.
#   2. Run from the terminal: bash fix_unused.sh
# -----------------------------------------------------------------------------

set -e

# --- CONFIGURATION ---
# =============================================================================
# *** MODIFY YOUR SETTINGS HERE ***
INPUT_PATH="datasets/tmp/converted_total_theorems.json"
OUTPUT_PATH="datasets/tmp/fixed_converted_total_theorems.json"
# =============================================================================

python src/fix_unused.py --input_file $INPUT_PATH --output_file $OUTPUT_PATH