#!/bin/bash
# -----------------------------------------------------------------------------
# This is a Bash script to run the Lean mutation pipeline.
#
# Workflow:
#   1. Data extraction (data_extract.py): extract and mutate all theorems from the input file (including imports).
#
# Usage:
#   1. Set all paths and parameters in the "CONFIGURATION" section.
#   2. Run from the terminal: bash mutate_jsonfile.sh
# -----------------------------------------------------------------------------

set -e

# --- CONFIGURATION ---
# =============================================================================
# *** MODIFY YOUR SETTINGS HERE ***
INPUT_PATH="datasets/raw/Leanworkbook.json"
OUTPUT_PATH="datasets/extracted/Leanworkbook.json"
# =============================================================================

python src/mutate_jsonfile.py --input_file $INPUT_PATH --output_file $OUTPUT_PATH