#!/bin/bash
# -----------------------------------------------------------------------------
# This is a Bash script to run the Lean mutation pipeline.
#
# Workflow:
#   1. Mutation (mutate.lean): extract and mutate all theorems from the input file (including imports).
#   2. Data creation (data_create.py): convert the extracted theorems into a JSON format.
#   3. Data check (data_check.py): check the validity of the JSON data.
#
# Usage:
#   1. Set all paths and parameters in the "CONFIGURATION" section.
#   2. Run from the terminal: bash mutate_leanfile.sh
# -----------------------------------------------------------------------------

set -e

# --- CONFIGURATION ---
# =============================================================================
# *** MODIFY YOUR SETTINGS HERE ***
INPUT_PATH="Mutation/Source/example.lean"
OUTPUT_PATH="datasets/raw/example.json"
# =============================================================================

### run mutation
theory=$(echo $INPUT_PATH | sed 's|\/|.|g' | sed 's|\.lean$||')
lake exe mutation $theory | python src/mutate_leanfile.py --dir $OUTPUT_PATH
