from lean_verifier import LeanVerifier 

statement = "import Mutation.Tactics\n\nimport Mathlib\n\ntheorem test : 1 = 1 := by simp"

with LeanVerifier() as verifier:
    # result = verifier.verify_single(statement)
    result = verifier.verify_batch([statement]*100, timeout=60, use_tqdm=True)

print(result[0])
assert result == [{'response': {'env': 0}, 'error': None}]*100
print("test passed")

statement = """
import Mutation.Tactics
import Mathlib

open MeasureTheory


theorem putnam_1962_a1
(S : Set (ℝ × ℝ))
(hS : S.ncard = 5)
(hnoncol : ∀ s ⊆ S, s.ncard = 3 → ¬Collinear ℝ s)
: ∃ T ⊆ S, T.ncard = 4 ∧ ¬∃ t ∈ T, t ∈ convexHull ℝ (T \ {t}) := by 

  have_with_extraction h_main : ∃ (T : Set (ℝ × ℝ)), T ⊆ S ∧ T.ncard = 4 ∧ ¬∃ (t : ℝ × ℝ), t ∈ T ∧ t ∈ convexHull ℝ (T \ {t}) := by
    classical
    have_with_extraction h₁ : ∃ (T : Set (ℝ × ℝ)), T ⊆ S ∧ T.ncard = 4 ∧ ¬∃ (t : ℝ × ℝ), t ∈ T ∧ t ∈ convexHull ℝ (T \ {t}) := by
      classical
      by_contra! h
      have_with_extraction h₂ := h ∅
      have_with_extraction h₃ := h S
      simp_all [subset_iff]
      <;>
      (try contradiction) <;>
      (try norm_num) <;>
      (try
        {
          exfalso
          have_with_extraction h₄ := hnoncol ∅ (by simp) (by simp)
          simp_all [subset_iff]
          <;>
          (try contradiction) <;>
          (try norm_num)
        })
      <;>
      (try
        {
          exfalso
          have_with_extraction h₄ := hnoncol S (by simp) (by
            simp_all [hS]
            <;>
            (try contradiction) <;>
            (try norm_num)
          )
          simp_all [subset_iff]
          <;>
          (try contradiction) <;>
          (try norm_num)
        })
      <;>
      (try
        {
          exfalso
          have_with_extraction h₄ := hnoncol ∅ (by simp) (by simp)
          simp_all [subset_iff]
          <;>
          (try contradiction) <;>
          (try norm_num)
        })
      <;>
      (try
        {
          exfalso
          have_with_extraction h₄ := hnoncol S (by simp) (by
            simp_all [hS]
            <;>
            (try contradiction) <;>
            (try norm_num)
          )
          simp_all [subset_iff]
          <;>
          (try contradiction) <;>
          (try norm_num)
        })
      <;>
      (try
        {
          exfalso
          have_with_extraction h₄ := hnoncol ∅ (by simp) (by simp)
          simp_all [subset_iff]
          <;>
          (try contradiction) <;>
          (try norm_num)
        })
      <;>
      (try
        {
          exfalso
          have_with_extraction h₄ := hnoncol S (by simp) (by
            simp_all [hS]
            <;>
            (try contradiction) <;>
            (try norm_num)
          )
          simp_all [subset_iff]
          <;>
          (try contradiction) <;>
          (try norm_num)
        })
    exact h₁
  obtain ⟨T, hT_sub, hT_card, hT⟩ := h_main
  refine' ⟨T, hT_sub, hT_card, _⟩
  simpa [Set.mem_setOf_eq] using hT
"""

with LeanVerifier() as verifier:
    result = verifier.verify_single(statement)
    # result = verifier.verify_batch([statement]*2, timeout=60, use_tqdm=True)

print(result)
assert result['error'] == None
print("test passed")