export HF_ENDPOINT="https://hf-mirror.com"
hf auth login --token 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

mkdir -p logs

export CUDA_VISIBLE_DEVICES=4,5,6,7 && 
export VLLM_USE_V1=1 &&
export VLLM_LOGGING_LEVEL=INFO && 
export LEANSERVER_LOG_DIR="./logs/lean_server.log"

timestamp=$(date +%Y%m%d_%H%M%S)
mkdir -p save/train_${timestamp}

# --solver_path "models/DeepSeek-R1-0528-Qwen3-8B_counterexample_solve" \
# --solver_path "models/mistral-7b_full_sft_counterexample_solve" \

python src/step1_solve_counter_example.py \
    --solver_name erdos \
    --solver_path "models/Qwen3-8B_counterexample_solve" \
    --gpu 4 \
    --num_problems 100000 \
    --dataset_path "datasets/train_data.json" \
    --solver_k 2 \
    --max_tokens 4096 \
    --save_dir "save/train_${timestamp}"

python src/step2_generate_formal_proof.py \
    --prover_name erdos \
    --prover_path "models/dsproverv2-7b_full_sft_formalproof_generate" \
    --gpu 4 \
    --default_header 1 \
    --input_file "save/train_${timestamp}/step1_solve_counter_example_train_data_100000_erdos_2.json" \
    --prover_k 2 \
    --max_tokens 4096 \
    --total_segments 10 \

# python src/step3_check_data_label.py \
#     --input_file "save/train_${timestamp}/step2_generate_formal_proof_train_data_100000_erdos_2_erdos_2.json" \
#     --batch_size 128 \
#     --total_segments 10 \

# export CUDA_VISIBLE_DEVICES=4,5,6,7 && python src/step4_update_model_params.py \
#     --solver_name erdos \
#     --prover_nameerdos \
#     --input_file "save/train_${timestamp}/step3_check_data_label_train_data_100000_erdos_2_erdos_2_check.json" 


