import Mathlib.Lean.CoreM
import Mathlib.Tactic.Common
import Mutation.HypDrop

open Lean Core Elab IO Meta Term Tactic

def Lean.ConstantInfo.kind : ConstantInfo → String
  | .axiomInfo  _ => "axiom"
  | .defnInfo   _ => "def"
  | .thmInfo    _ => "theorem"
  | .opaqueInfo _ => "opaque"
  | .quotInfo   _ => "quot" -- Not sure what this is!
  | .inductInfo _ => "inductive"
  | .ctorInfo   _ => "constructor"
  | .recInfo    _ => "recursor"

def isBlackListedPlus (declName : Name) : Bool :=
  if declName.toString.startsWith "Std" then true
  else if declName.toString.startsWith "Lean" then true
  else if declName.toString.startsWith "Mathlib.Tactic" then true
  else if declName.toString.startsWith "Mathlib.Util" then true
  else if declName.toString.startsWith "Aesop" then true
  else false

def useExtractGoal (name : Name) (idx : Nat) : TacticM Unit := do
  evalTactic (← `(tactic| dropHyp $(mkIdent name) $(quote idx)))

def main (args : List String) : IO UInt32 := do
  unsafe enableInitializersExecution
  let options := Options.empty.insert `maxHeartbeats (0 : Nat)
  let options := options.insert `pp.maxSteps (1000000 : Nat)
  let impArgs := args.append ["Mutation.Tactics"]
  let modules := match impArgs with
  | [] => #[`Mathlib]
  | args => args.toArray.map fun s => s.toName
  initSearchPath (← findSysroot)
  CoreM.withImportModules modules (options := options) do
    IO.println s!"[" -- start of list
    for (n, c) in (← getEnv).constants.map₁ do
      if c.isTheorem ∧ ! (← n.isBlackListed) ∧ ! (isBlackListedPlus n) then
        IO.println s!"--<<SEP>>--"
        IO.println s!"name: {n}"
        IO.println s!"original_version: theorem {n} : {(← MetaM.run' do ppExpr c.type)} := sorry"
        for i in [0:128] do
          let name := n.appendAfter s!"_drop{i}"
          let tac ← pure (useExtractGoal name i)
          let stop ← MetaM.run' do
            let goal ← mkFreshExprMVar c.type
            try
              let _ ← TermElabM.run' (Tactic.run goal.mvarId! tac)
              pure false
            catch _ =>
              pure true
          if stop then
            break
    IO.println s!"]" -- end of list
  return 0
