#!/usr/bin/env python3
import json
import glob
import os

# Get all json files in save directory
json_files = glob.glob("./datasets/save/*.json")
print(f"Totally found {len(json_files)} JSON files")
print("Note: update to now, full versions of theorems are not included in the data")

# Merge all data
total_data = []
for file_path in json_files:
    print(f"Processing: {os.path.basename(file_path)}")
    if os.path.basename(file_path) == "example.json":
        print("Skip example.json")
        continue
    try:
        with open(file_path, 'r', encoding='utf-8') as f:
            data = json.load(f)
        print(f"  Found {len(data)} records for {os.path.basename(file_path)}")
        for item in data:
            total_data.append({
                "name": item['name'],
                "imports": item['imports'],
                "formal_statement": item['formal_statement'],
                "dropped_hypothesis": item['dropped_hypothesis'],
            })
    except Exception as e:
        print(f"  Error: {e}")

# Save merged data
output_file = "datasets/output/total_data.json"
with open(output_file, 'w', encoding='utf-8') as f:
    json.dump(total_data, f, ensure_ascii=False, indent=2)

print(f"\nMerged completed! Totally {len(total_data)} records")
print(f"Output file: {output_file}")
