from lean_verifier import LeanVerifier 

statement = """
import Mutation.Tactics
import Mathlib
import Aesop

set_option maxHeartbeats 0

open BigOperators Real Nat Topology Rat


theorem mathd_algebra_13_g1_12 (n : ℕ) (h₁ h₂ h₄ : n % 3 = 1) (h₅ : n ^ 3 % 3 = 1) (this : n % 3 = 1) :  2 * n % 3 = 2 := by replMutation 0; sorry
"""


with LeanVerifier() as verifier:
    # result = verifier.verify_single(statement)
    result = verifier.verify_batch([statement]*2, timeout=60, use_tqdm=True)

print(result)
assert result['error'] == None
print("test passed")