import numpy as np
from tensorflow import keras
from tensorflow.keras import layers
import cv2,xlrd
import os


learning_rate = 0.001
batch_size = 3
hidden_units = 512
num_epochs = 50
dropout_rate = 0.5
num_classes = 27
resolution = (224, 224)
input_shape = (224, 224, 3)


Train_Ann = r".\Train.xlsx" #category,bounding box, and area annotations
Train_Img_path = r"" #Enter COCO image path here



def get_small_instances(Xlsxpath, CutoffArea, small_idx=None):

    wb = xlrd.open_workbook(Xlsxpath)
    ws = wb.sheet_by_index(0)

    filename = ws.col_values(0, start_rowx=1)

    BBox_x = ws.col_values(1, start_rowx=1)
    BBox_y = ws.col_values(2, start_rowx=1)
    BBox_w = ws.col_values(3, start_rowx=1)
    BBox_h = ws.col_values(4, start_rowx=1)

    catID = ws.col_values(5, start_rowx=1)
    Area = ws.col_values(6, start_rowx=1)

    if small_idx is None:
        Class_wise_Areas = []
        for i in range(90):
            Class_wise_Areas.append([0])

        for i in range(len(catID)):
            Class_wise_Areas[int(catID[i]) - 1].append(Area[i])
        means = []
        for Class_wise_Area in Class_wise_Areas:
            del Class_wise_Area[0]
            if np.isnan(np.asarray(Class_wise_Area).mean()):
                means.append(np.inf)
            else:
                means.append(np.asarray(Class_wise_Area).mean())
        small_idx = [n+1 for n, i in enumerate(means) if i < CutoffArea]

    small_area_idxs=[]
    for i in range(len(catID)):
        if catID[i] in small_idx:
            small_area_idxs.append(int(i))

    small_area_BBox=[[BBox_x[i],BBox_y[i],BBox_w[i],BBox_h[i]] for i in small_area_idxs]
    small_area_filename=[filename[i] for i in small_area_idxs]
    small_area_catID = [int(catID[i]) for i in small_area_idxs]
    return small_area_filename, small_area_BBox, small_area_catID
def aspect_ratio_var(X, Y, BBoxes, aspect_ratio):
    Aug_X=[]
    Aug_Y=[]

    for i in range(len(BBoxes)):
        img = X[i]
        cat = Y[i]

        for r_x in aspect_ratio:
            for r_y in aspect_ratio:
                BBimg = np.zeros(img.shape)
                for BB in BBoxes[i]:

                    C_x = int(BB[0])
                    C_y = int(BB[1])

                    w_half = int(BB[2]*r_x/2)
                    h_half = int(BB[3]*r_y/2)

                    x_min = np.clip(C_x - w_half, a_min=0, a_max=img.shape[0])
                    x_max = np.clip(C_x + w_half, a_min=0, a_max=img.shape[0])
                    y_min = np.clip(C_y - h_half, a_min=0, a_max=img.shape[1])
                    y_max = np.clip(C_y + h_half, a_min=0, a_max=img.shape[1])

                    BBimg[y_min:y_max, x_min:x_max] = img[y_min:y_max, x_min:x_max]

                Aug_X.append(cv2.resize(np.array(BBimg), resolution))
                Aug_Y.append(cat)

    return Aug_X,Aug_Y
def generate_sequences(Xlsxpath, Imgpath, CutoffArea, batch_size, aspect_ratio,
                       small_idx=None):

    filename, BBox, catID = get_small_instances(Xlsxpath, CutoffArea=CutoffArea, small_idx=small_idx)
    set_CatID=list(set(catID))
    cat_label=[set_CatID.index(idx) for idx in catID]

    dict_cat = {}
    dict_BB = {}
    for idx in range(len(filename)):
        if filename[idx] not in dict_cat:
            dict_cat[filename[idx]] = [cat_label[idx]]
            dict_BB[filename[idx]] = [BBox[idx]]
        else:
            if cat_label[idx] not in dict_cat[filename[idx]]:
                dict_cat[filename[idx]].append(cat_label[idx])
                dict_BB[filename[idx]].append(BBox[idx])
            else:
                continue
    while True:
        training_sample_count = len(dict_cat)
        sample_idxs = range(0, training_sample_count)
        sample_idxs = np.random.permutation(sample_idxs)

        batches = int(training_sample_count / batch_size)
        remainder_samples = training_sample_count % batch_size

        if remainder_samples:
            batches = batches + 1
        for idx in range(batches):
            if idx == batches - 1:
                batch_idxs = sample_idxs[idx * batch_size:]
            else:
                batch_idxs = sample_idxs[idx * batch_size:idx * batch_size + batch_size]

            X = [cv2.imread(os.path.join(Imgpath, list(dict_cat)[idx])) for idx in batch_idxs]
            Y = [list(dict_cat.values())[idx] for idx in batch_idxs]
            Y = [np.sum(np.eye(len(set_CatID))[Y[idx]], axis=0) for idx in range(len(Y))]
            BBoxes=[list(dict_BB.values())[idx] for idx in batch_idxs]

            Aug_X,Aug_Y = aspect_ratio_var(X, Y, BBoxes, aspect_ratio)
            yield (np.array(Aug_X), np.array(Aug_Y))

training_sequence_generator = generate_sequences(Train_Ann,
                                                 Train_Img_path,
                                                 CutoffArea=0.02, ## Cut-off area 2%
                                                 batch_size=batch_size,
                                                 aspect_ratio=[1.0, 1.5, 2.0])

data_augmentation = keras.Sequential(
    [
        layers.experimental.preprocessing.Rescaling(scale=1./127.5, offset=-1),
        layers.experimental.preprocessing.RandomFlip("horizontal"),
        layers.experimental.preprocessing.RandomRotation(0.05),
        layers.experimental.preprocessing.RandomWidth(0.9),
        layers.experimental.preprocessing.RandomHeight(0.9),
    ]
)


def create_encoder():
    resnet = keras.applications.ResNet50(
        include_top=False, weights=None, input_shape=input_shape, pooling="avg")

    inputs = keras.Input(shape=input_shape)
    augmented = data_augmentation(inputs)
    outputs = resnet(augmented)
    model = keras.Model(inputs=inputs, outputs=outputs, name="encoder")
    return model

encoder = create_encoder()
encoder.summary()


def create_classifier(encoder, trainable=True):

    for layer in encoder.layers:
        layer.trainable = trainable

    inputs = keras.Input(shape=input_shape)
    features = encoder(inputs)
    features = layers.Dropout(dropout_rate)(features)
    features = layers.Dense(hidden_units, activation="tanh")(features)
    features = layers.Dropout(dropout_rate)(features)
    features = layers.Dense(num_classes, activation=None)(features)
    outputs = layers.Activation('sigmoid')(features)

    model = keras.Model(inputs=inputs, outputs=outputs, name="classifier")
    model.compile(
        optimizer=keras.optimizers.Adam(learning_rate),
        loss=keras.losses.BinaryCrossentropy()
    )
    return model


encoder = create_encoder()
classifier = create_classifier(encoder)
classifier.summary()


history = classifier.fit_generator(generator=training_sequence_generator,
                                   steps_per_epoch=int(66612 / batch_size),
                                   epochs=num_epochs,
                                   verbose=1)




