#!/bin/bash

GPU_ID=${1}
MODEL_NUM=${2}
export CUDA_VISIBLE_DEVICES=$GPU_ID
DATASET_ARR=(mnist fmnist kmnist svhn cifar10 emnistlet emnistdig)
METHOD_ARR=(lewisweight )
BATCH_SIZE=${3}

echo "Running with ${MODEL_NUM} target models on GPU ${GPU_ID}..."
echo "Settings: ${DATASET_ARR[*]} ${METHOD_ARR[*]}"

for NET in $(seq 0 1 $(($MODEL_NUM-1)))
do
   for DATASET in ${DATASET_ARR[*]}
   do
       python train_net.py --al_iter 0 --net_id $NET --dataset $DATASET
   done
done

for DATASET in ${DATASET_ARR[*]}
do
 	for METHOD in ${METHOD_ARR[*]}
	do
      echo "Running ${DATASET} ${METHOD} active select"
      python al_select.py --method $METHOD --dataset $DATASET --al_iter 0 --batch_size $BATCH_SIZE --model_num $MODEL_NUM
  done
done

for METHOD in ${METHOD_ARR[*]}
do

  for DATASET in ${DATASET_ARR[*]}
    do

    for NET in $(seq 0 1 $(($MODEL_NUM-1)))
    do
        echo "Running ${DATASET} ${METHOD} ${ITER}"
        python train_net.py --net_id $NET --dataset $DATASET --al_iter 1 --method $METHOD 
    done

    done
done


echo "test phase..."
for DATASET in ${DATASET_ARR[*]}
do
  for METHOD in ${METHOD_ARR[*]}
  do
    echo "testing ${DATASET} ${METHOD} ${ITER}"
    python test_multi_models.py --dataset $DATASET --method $METHOD --al_iter 1 --model_num $MODEL_NUM
  done
done
