#!/bin/bash

GPU_ID=${1}
MODEL_NUM=${2}
export CUDA_VISIBLE_DEVICES=$GPU_ID
DATASET_ARR=(biwi flw)
METHOD_ARR=(lewisweight random coreset qbc)
BATCH_SIZE=${3}

echo "Running AL regression with ${MODEL_NUM} target models on GPU ${GPU_ID}..."
echo "Settings: ${DATASET_ARR[*]} ${METHOD_ARR[*]}"

for DATASET in ${DATASET_ARR[*]}
 do

 for NET in $(seq 0 1 $(($MODEL_NUM-1)))
 do
     echo "Running ${DATASET} ${METHOD} ${ITER}"
     python train_net.py --net_id $NET --dataset $DATASET --al_iter 0 --method random --regression
 done
done

for DATASET in ${DATASET_ARR[*]}
do
	for METHOD in ${METHOD_ARR[*]}
	do
      echo "Running ${DATASET} ${METHOD} active select"
      python al_select_regression.py --method $METHOD --dataset $DATASET --al_iter 0 --batch_size $BATCH_SIZE --model_num $MODEL_NUM
  done
done

for ITER in $(seq 1 1 1);
do
  for METHOD in ${METHOD_ARR[*]}
  do

    for DATASET in ${DATASET_ARR[*]}
      do

      for NET in $(seq 0 1 $(($MODEL_NUM-1)))
      do
          echo "Running ${DATASET} ${METHOD} ${ITER}"
          python train_net.py --net_id $NET --dataset $DATASET --al_iter $ITER --method $METHOD --regression 
      done

  done
done
done

echo "test phase..."
for ITER in $(seq 0 1 1);
do
  for DATASET in ${DATASET_ARR[*]}
  do
    for METHOD in ${METHOD_ARR[*]}
    do
      echo "testing ${DATASET} ${METHOD} ${ITER}"
      python test_multi_models.py --dataset $DATASET --method $METHOD --al_iter $ITER --model_num $MODEL_NUM --regression
    done
  done
done
