parent_batch_id=$1
cd data || exit 1
domains="domains.txt"
batch_id=$(cat /proc/sys/kernel/random/uuid)
cat $domains | while read -r domain;
do
		echo "$domain $batch_id $(jq ".$domain.train" splits.json -c) $(jq ".$domain.test" splits.json -c)"
		train_set=$(jq ".$domain.train" splits.json -c)
		eval_set=$(jq ".$domain.test" splits.json -c)
		parent_run_id=$(uv run get_run_id_for_batch_domain "$parent_batch_id" "$domain")
		parent_path=$(uv run get_artifact_for_run "$parent_run_id")
		uv run run_domain "$domain" "$batch_id" "$train_set" "$eval_set" --resume-from ../"$parent_path" >> "$batch_id.jsonl" &
done
