from all_data import get_all_data
from seaborn import boxplot

df = get_all_data()
df = df[df["batch_id"] == "37290af5-1d7d-4d35-88fe-6fcf8ffc5868"]
df = df.drop("batch_id", axis=1)
df = df[~df["is_train"]]
df = df.drop("is_train", axis=1)
df = df.drop("instance", axis=1)

df = df.rename(
    columns={
        "score": "vejde",
    }
)

df[["domain", "prost", "mlp", "vejde"]].groupby(["domain"])

df = df.melt(
    id_vars=["domain"],
    value_vars=["prost", "mlp", "vejde"],
    var_name="model",
    value_name="score",
)

import matplotlib.pyplot as plt

# eight domains
figure, axs = plt.subplots(ncols=2, nrows=4, figsize=(10, 12))


for name, group in df.groupby(["domain"]):
    ax = axs.flatten()[0]
    boxplot(x="model", y="score", data=group, ax=ax)
    ax.set_title(name[0].replace("_MDP_ippc", " "))
    ax.set_xlabel("Model")
    ax.set_ylabel("Score")
    ax.set_ylim(0, 1)
    axs = axs.flatten()[1:]


plt.tight_layout()
plt.savefig("box_plot_per_domain.pdf", dpi=300)
plt.show()
