from rddlrepository import RDDLRepoManager
from pathlib import Path


def create_dirs(domain):
    prost_dir = Path("prost_problems")
    prost_dir.mkdir(exist_ok=True)

    manager = RDDLRepoManager(rebuild=True)
    problem = manager.get_problem(domain)

    instances = problem.list_instances()

    with open(problem.get_domain(), "r") as f:
        domain_rddl = f.read()

    domain_dir = prost_dir / domain
    domain_dir.mkdir(exist_ok=True)

    for i in instances:
        instance_dir = domain_dir / f"{i}"
        instance_dir.mkdir(exist_ok=True)

        with open(instance_dir / "domain.rddl", "w") as f:
            f.write(domain_rddl)

        with open(problem.get_instance(i), "r") as f:
            instance_rddl = f.read()
        with open(instance_dir / "instance.rddl", "w") as f:
            f.write(instance_rddl)


domains = [
    "Tamarisk_MDP_ippc2014",
    "TriangleTireworld_MDP_ippc2014",
    "Elevators_MDP_ippc2014",
    "SysAdmin_MDP_ippc2011",
    "Navigation_MDP_ippc2011",
    "Traffic_MDP_ippc2014",
    "SkillTeaching_MDP_ippc2014",
    "AcademicAdvising_MDP_ippc2014",
    "CrossingTraffic_MDP_ippc2014",
    "Wildfire_MDP_ippc2014",
    "GameOfLife_MDP_ippc2011",
]

for d in domains:
    create_dirs(d)
