#!/bin/bash

batch_id=$1
echo "$batch_id"
outpath=data/eval_$batch_id.jsonl
rm "$outpath" 2> /dev/null
for run in $(uv run get_runs_of_batch "$batch_id"); 
do
	model_path=$(uv run get_artifact_for_run "$run")
	domain=$(uv run get_domain_for_run "$run")
	echo "$domain" "$run"
	uv run evaluate "$domain" "$run" "$model_path" True "$batch_id" >> "$outpath"
done