batch_id=$1
rm data/eval_"$batch_id".jsonl 2>/dev/null
jq -c '.[] | [.domain, .agent_path, .train_instances]' data/imitation_output/fix_$batch_id.json | while read -r json; do
	
	domain=$(jq -r '.[0]' <<< "$json")
	#echo "Domain: $domain"
	agent_path=$(jq -r '.[1]' <<< "$json")
	#echo "Agent Path: $agent_path"
	train_instances=$(jq -r '.[2]' <<< "$json")
	data=$(uv run eval_mimics "$batch_id" "$domain" data/imitation_output/"$agent_path" $train_instances)
	jq -c '. += {'train_instances': '"$train_instances"'}' <<< "$data" >> data/eval_"$batch_id".jsonl
done