from pathlib import Path
import orjson as json
import re
data_file = Path('.').glob("nv/data_*.json")
other_data_path = Path('/home/jakob/pyRDDLGym-prost/outputnav/Navigation_MDP_ippc2011/')

for d in data_file:

	with d.open() as f:
		json_data = json.loads(f.read())
		if len(json_data) < 10:
			instance = re.search(r'(\d\d?).json', str(d.name)).group(1)
			other_data_file = other_data_path / instance / 'OUTPUTS' / d.name
			assert other_data_file.is_file(), f"Other data file {other_data_file} does not exist"
			with other_data_file.open() as other_f:
				try:
					other_json_data = json.loads(other_f.read())
				except json.JSONDecodeError:
					print(f"Error decoding JSON from {other_data_file}")
					other_json_data = []

			full_data = json_data + other_json_data
			full_data = full_data[:10]
			print(len(full_data))
			with open(str(d.name), 'wb') as out_f:
				out_f.write(json.dumps(full_data))
		