import json

with open("data/prost_summaries.jsonl") as f:
    prost_data = [json.loads(l) for l in f.readlines()]

domains = set(d["domain"] for d in prost_data)


combined_data = {d: [0] * 10 for d in domains}

for d in prost_data:
    domain = d["domain"]
    instance = int(d["instance"])
    combined_data[domain][instance - 1] = (d["summary"]["mean"], d["summary"]["std"])


print(json.dumps(combined_data))

pass
