from regawa.rl.ppo_gnn import setup, Args
from regawa import GNNParams, ActionMode
from torch import nn
from regawa.rddl import register_env

env_id = register_env()
args = Args(
    env_id=env_id,
    debug=False,
    total_timesteps=200000,
    num_steps=128,
    anneal_lr=False,
    num_minibatches=1,
    learning_rate=0.01,
    ent_coef=0.01,
    vf_coef=0.01,
    gamma=1.0,
    gae_lambda=0.95,
    norm_adv=True,
    clip_coef=0.2,
    update_epochs=10,
    target_kl=0.01,
    remove_false=True,
    domain="AcademicAdvising_ippc2018",
    instance=1,
    agent_config=GNNParams(
        layers=2,
        embedding_dim=32,
        activation=nn.Mish(),
        aggregation="max",
        action_mode=ActionMode.ACTION_THEN_NODE,
    ),
)
setup(args)
