import mlflow
import mlflow.artifacts
import mlflow.artifacts
from pathlib import Path
from mlflow.entities import Run


def get_runs_by_query(search_string: str) -> list[Run]:
    return mlflow.search_runs(
        search_all_experiments=True, filter_string=search_string, output_format="list"
    )


def get_runs_by_ids(ids: list[str]):
    r = [mlflow.get_run(i) for i in ids]
    return r


def get_artifact_for_run(r: Run):
    uri = r.info.artifact_uri
    artifacts = mlflow.artifacts.list_artifacts(artifact_uri=uri)
    for a in artifacts:
        if "pth" in a.path:
            uri = uri.replace("file://", "")
            uri = uri.replace("mlflow-artifacts:", "mlartifacts")
            return str((Path(uri) / Path(a.path).name).absolute())


def get_artifact_paths(runs: list[Run]) -> dict[str, Path]:
    run_artifacts = {}
    for r in runs:
        run_id = r.info.run_id
        run_artifacts[run_id] = get_artifact_for_run(r)
    return run_artifacts
