import sys


import pyRDDLGym

from pyRDDLGym.core.policy import NoOpAgent
import json

from rddleval.scripts.rddlgym_eval import evaluate


def run(domain: str, instance: str):
    # set up the environment
    env = pyRDDLGym.make(
        domain,
        instance,
        enforce_action_constraints=False,
    )

    # wrap the agent in a RDDL policy and evaluate
    agent = NoOpAgent(None)
    instance_returns = evaluate(env, agent, episodes=100, seed=0)

    env.close()

    return list(instance_returns)


def main():
    args = sys.argv[1:]

    instance_returns = [run(domain=args[0], instance=str(i)) for i in range(1, 11)]

    data = {
        "batch_id": "null",
        "run_id": "null",
        "domain": args[0],
        "instance_returns": list(instance_returns),
    }

    print(json.dumps(data))
