from typing import Any
from regawa import GraphAgent
import sys
import json
import torch


class JsonSerializer(json.JSONEncoder):
    def default(self, o: Any) -> Any:
        if isinstance(o, torch.Tensor):
            return o.tolist()


def main():
    path = sys.argv[1]

    agent, _ = GraphAgent.load_agent(path)

    print(json.dumps(agent.state_dict(), cls=JsonSerializer))


if __name__ == "__main__":
    main()
