import mlflow
import sys

from rddleval.artifacts import get_runs_by_query


def main():
    mlflow.set_tracking_uri("http://localhost:5000")

    batch_id = sys.argv[1]
    domain = sys.argv[2]

    runs = get_runs_by_query(
        f"params.batch_id = '{batch_id}' and params.domain = '{domain}'"
    )

    for r in runs:
        print(r.info.run_id)


if __name__ == "__main__":
    main()
