import mlflow
import sys
import json


def format_list(x):
    return "[" + ",".join(map(str, [y - 1 for y in json.loads(x)])) + "]"


def main():
    mlflow.set_tracking_uri("http://localhost:5000")

    run_id = sys.argv[1]
    r = mlflow.get_run(run_id)
    print(
        format_list(r.data.params["instance"]),
        format_list(r.data.params["eval_instance"]),
    )


if __name__ == "__main__":
    main()
