cd data || exit 1
domains="domains.txt"
batch_id=$(cat /proc/sys/kernel/random/uuid)
cat $domains | while read -r domain;
do
	for i in {1..5};
		do
		
		train_set=$(jq ".$domain.train" "splits_$i.json" -c)
		eval_set=$(jq ".$domain.test" "splits_$i.json" -c)
		echo "$domain $batch_id $train_set $eval_set"
		uv run run_domain "$domain" "$batch_id" "$train_set" "$eval_set" warmup >> "$batch_id.jsonl"
	done
done
