cd data || exit 1
domains="domains.txt"
batch_id=$(cat /proc/sys/kernel/random/uuid)
cat $domains | while read -r domain;
do
	echo "Processing domain: $domain"
	for datafile in "prostdata__$domain"__*;
		do
			instances=$(echo "$datafile" | grep -P "\[.*\]" -o)
			echo "$datafile $domain $batch_id" "$instances"
			uv run train_mimic "$datafile" "$domain" "$batch_id" "$instances" >> "imitation_output/$batch_id.jsonl"
		done
done

jq -s '.' "imitation_output/$batch_id.jsonl" > "imitation_output/$batch_id.json"