# 评测

SWIFT支持了eval（评测）能力，用于对原始模型和训练后的模型给出标准化的评测指标。

## 能力介绍

SWIFT的eval能力使用了魔搭社区[评测框架EvalScope](https://github.com/modelscope/eval-scope)，并进行了高级封装以支持各类模型的评测需求。

> 注意：EvalScope支持许多其他的复杂能力，例如[模型的性能评测](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/stress_test/quick_start.html)，请直接使用EvalScope框架。

目前我们支持了**标准评测集**的评测流程，以及**用户自定义**评测集的评测流程。其中**标准评测集**由三个评测后端提供支持：

下面展示所支持的数据集名称，若需了解数据集的详细信息，请参考[所有支持的数据集](https://evalscope.readthedocs.io/zh-cn/latest/get_started/supported_dataset.html)

1. Native（默认）：

    主要支持纯文本评测，同时**支持**评测结果可视化
    ```text
    'arc', 'bbh', 'ceval', 'cmmlu', 'competition_math',
    'general_qa', 'gpqa', 'gsm8k', 'hellaswag', 'humaneval',
    'ifeval', 'iquiz', 'mmlu', 'mmlu_pro',
    'race', 'trivia_qa', 'truthful_qa'
    ```

2. OpenCompass：

    主要支持纯文本评测，暂**不支持**评测结果可视化
    ```text
    'obqa', 'cmb', 'AX_b', 'siqa', 'nq', 'mbpp', 'winogrande', 'mmlu', 'BoolQ', 'cluewsc', 'ocnli', 'lambada',
    'CMRC', 'ceval', 'csl', 'cmnli', 'bbh', 'ReCoRD', 'math', 'humaneval', 'eprstmt', 'WSC', 'storycloze',
    'MultiRC', 'RTE', 'chid', 'gsm8k', 'AX_g', 'bustm', 'afqmc', 'piqa', 'lcsts', 'strategyqa', 'Xsum', 'agieval',
    'ocnli_fc', 'C3', 'tnews', 'race', 'triviaqa', 'CB', 'WiC', 'hellaswag', 'summedits', 'GaokaoBench',
    'ARC_e', 'COPA', 'ARC_c', 'DRCD'
    ```

3. VLMEvalKit:

    主要支持多模态评测，暂**不支持**评测结果可视化
    ```text
    'COCO_VAL', 'MME', 'HallusionBench', 'POPE', 'MMBench_DEV_EN', 'MMBench_TEST_EN', 'MMBench_DEV_CN', 'MMBench_TEST_CN',
    'MMBench', 'MMBench_CN', 'MMBench_DEV_EN_V11', 'MMBench_TEST_EN_V11', 'MMBench_DEV_CN_V11',
    'MMBench_TEST_CN_V11', 'MMBench_V11', 'MMBench_CN_V11', 'SEEDBench_IMG', 'SEEDBench2',
    'SEEDBench2_Plus', 'ScienceQA_VAL', 'ScienceQA_TEST', 'MMT-Bench_ALL_MI', 'MMT-Bench_ALL',
    'MMT-Bench_VAL_MI', 'MMT-Bench_VAL', 'AesBench_VAL', 'AesBench_TEST', 'CCBench', 'AI2D_TEST', 'MMStar',
    'RealWorldQA', 'MLLMGuard_DS', 'BLINK', 'OCRVQA_TEST', 'OCRVQA_TESTCORE', 'TextVQA_VAL', 'DocVQA_VAL',
    'DocVQA_TEST', 'InfoVQA_VAL', 'InfoVQA_TEST', 'ChartQA_TEST', 'MathVision', 'MathVision_MINI',
    'MMMU_DEV_VAL', 'MMMU_TEST', 'OCRBench', 'MathVista_MINI', 'LLaVABench', 'MMVet', 'MTVQA_TEST',
    'MMLongBench_DOC', 'VCR_EN_EASY_500', 'VCR_EN_EASY_100', 'VCR_EN_EASY_ALL', 'VCR_EN_HARD_500',
    'VCR_EN_HARD_100', 'VCR_EN_HARD_ALL', 'VCR_ZH_EASY_500', 'VCR_ZH_EASY_100', 'VCR_ZH_EASY_ALL',
    'VCR_ZH_HARD_500', 'VCR_ZH_HARD_100', 'VCR_ZH_HARD_ALL', 'MMDU', 'MMBench-Video', 'Video-MME'
    ```

## 环境准备

```shell
pip install ms-swift[eval] -U
```

或从源代码安装：

```shell
git clone https://github.com/modelscope/ms-swift.git
cd ms-swift
pip install -e '.[eval]'
```

## 评测

支持纯文本评测、多模态评测、url评测、自定义数据集评测四种方式

**基本示例**

```shell
CUDA_VISIBLE_DEVICES=0 \
swift eval \
    --model Qwen/Qwen2.5-0.5B-Instruct \
    --eval_backend Native \
    --infer_backend pt \
    --eval_limit 10 \
    --eval_dataset gsm8k
```
其中:
- model: 可指定本地模型路径或者modelscope上的模型ID
- eval_backend: 可选 Native, OpenCompass, VLMEvalKit，默认为 Native
- infer_backend: 可选 pt, vllm, sglang, lmdeploy，默认为 pt
- eval_limit: 每个评测集的采样数，默认为None，表示使用全部数据，可用于快速验证
- eval_dataset: 评测数据集，可设置多个数据集，用空格分割

**复杂评测示例**

```shell
CUDA_VISIBLE_DEVICES=0 \
swift eval \
    --model Qwen/Qwen2.5-0.5B-Instruct \
    --eval_backend Native \
    --infer_backend pt \
    --eval_limit 10 \
    --eval_dataset gsm8k \
    --dataset_args '{"gsm8k": {"few_shot_num": 0, "filters": {"remove_until": "</think>"}}}' \
    --eval_generation_config '{"max_tokens": 512, "temperature": 0}' \
    --extra_eval_args '{"ignore_errors": true, "debug": true}'
```

详细评测的参数列表可以参考[这里](命令行参数.md#评测参数)。

## 训练中评测

SWIFT支持在训练过程中使用EvalScope对当前的模型进行评测，以便及时了解模型的训练效果。

**基本示例**

```shell
CUDA_VISIBLE_DEVICES=0 \
swift sft \
  --model "Qwen/Qwen2.5-0.5B-Instruct" \
  --train_type "lora" \
  --dataset "AI-ModelScope/alpaca-gpt4-data-zh#100" \
  --torch_dtype "bfloat16" \
  --num_train_epochs "1" \
  --per_device_train_batch_size "1" \
  --learning_rate "1e-4" \
  --lora_rank "8" \
  --lora_alpha "32" \
  --target_modules "all-linear" \
  --gradient_accumulation_steps "16" \
  --save_steps "50" \
  --save_total_limit "5" \
  --logging_steps "5" \
  --max_length "2048" \
  --eval_strategy "steps" \
  --eval_steps "5" \
  --per_device_eval_batch_size "5" \
  --eval_use_evalscope \
  --eval_dataset "gsm8k" \
  --eval_dataset_args '{"gsm8k": {"few_shot_num": 0}}' \
  --eval_limit "10"
```

注意启动命令为`sft`，其中eval相关的参数有：
- eval_strategy: 评估策略。默认为None，跟随`save_strategy`的策略
- eval_steps: 默认为None，如果存在评估数据集，则跟随`save_steps`的策略
- eval_use_evalscope: 是否使用evalscope进行评测，需要设置该参数来开启评测
- eval_dataset: 评测数据集，可设置多个数据集，用空格分割
- eval_dataset_args: 评测数据集参数，json格式，可设置多个数据集的参数
- eval_limit: 评测数据集采样数
- eval_generation_config: 评测时模型推理配置，json格式，默认为`{'max_tokens': 512}`


更多评测的样例可以参考[examples](https://github.com/modelscope/ms-swift/tree/main/examples/eval)

## 自定义评测集

本框架支持选择题和问答题，两种预定义的数据集格式，使用流程如下：

*注意：使用自定义评测时，eval_backend参数必须为Native*

### 选择题格式（MCQ）
适合用户是选择题的场景，评测指标为准确率（accuracy）。

**数据准备**

准备选择题格式的csv文件，该目录结构如下：

```text
mcq/
├── example_dev.csv  # （可选）文件名组成为`{subset_name}_dev.csv`，用于fewshot评测
└── example_val.csv  # 文件名组成为`{subset_name}_val.csv`，用于实际评测的数据
```

其中csv文件需要为下面的格式：

```text
id,question,A,B,C,D,answer
1,通常来说，组成动物蛋白质的氨基酸有____,4种,22种,20种,19种,C
2,血液内存在的下列物质中，不属于代谢终产物的是____。,尿素,尿酸,丙酮酸,二氧化碳,C
```
其中：
- `id`是序号（可选）
- `question`是问题
- `A`, `B`, `C`, `D`等是可选项，最大支持10个选项
- `answer`是正确选项

**启动评测**

运行下面的命令：

```bash
CUDA_VISIBLE_DEVICES=0 \
swift eval \
    --model Qwen/Qwen2.5-0.5B-Instruct \
    --eval_backend Native \
    --infer_backend pt \
    --eval_dataset general_mcq \
    --dataset_args '{"general_mcq": {"local_path": "/path/to/mcq", "subset_list": ["example"]}}'
```
其中：
- `eval_dataset` 需要设置为 `general_mcq`
- `dataset_args` 需要设置
    - `local_path` 自定义数据集文件夹路径
    - `subset_list` 评测数据集名称，上述 `*_dev.csv` 中的 `*`

**运行结果**

```text
+---------------------+-------------+-----------------+----------+-------+---------+---------+
| Model               | Dataset     | Metric          | Subset   |   Num |   Score | Cat.0   |
+=====================+=============+=================+==========+=======+=========+=========+
| Qwen2-0.5B-Instruct | general_mcq | AverageAccuracy | example  |    12 |  0.5833 | default |
+---------------------+-------------+-----------------+----------+-------+---------+---------+
```

## 问答题格式（QA）
适合用户是问答题的场景，评测指标是`ROUGE`和`BLEU`。

**数据准备**

准备一个问答题格式的jsonline文件，该目录包含了一个文件：

```text
qa/
└── example.jsonl
```

该jsonline文件需要为下面的格式：

```json
{"query": "中国的首都是哪里？", "response": "中国的首都是北京"}
{"query": "世界上最高的山是哪座山？", "response": "是珠穆朗玛峰"}
{"query": "为什么北极见不到企鹅？", "response": "因为企鹅大多生活在南极"}
```

**启动评测**

运行下面的命令：

```bash
CUDA_VISIBLE_DEVICES=0 \
swift eval \
    --model Qwen/Qwen2.5-0.5B-Instruct \
    --eval_backend Native \
    --infer_backend pt \
    --eval_dataset general_qa \
    --dataset_args '{"general_qa": {"local_path": "/path/to/qa", "subset_list": ["example"]}}'
```

其中：
- `eval_dataset` 需要设置为 `general_qa`
- `dataset_args` 是一个json字符串，需要设置：
    - `local_path` 自定义数据集文件夹路径
    - `subset_list` 评测数据集名称，上述 `*.jsonl` 中的 `*`

**运行结果**

```text
+---------------------+-------------+-----------------+----------+-------+---------+---------+
| Model               | Dataset     | Metric          | Subset   |   Num |   Score | Cat.0   |
+=====================+=============+=================+==========+=======+=========+=========+
| Qwen2-0.5B-Instruct | general_qa  | bleu-1          | default  |    12 |  0.2324 | default |
+---------------------+-------------+-----------------+----------+-------+---------+---------+
| Qwen2-0.5B-Instruct | general_qa  | bleu-2          | default  |    12 |  0.1451 | default |
+---------------------+-------------+-----------------+----------+-------+---------+---------+
| Qwen2-0.5B-Instruct | general_qa  | bleu-3          | default  |    12 |  0.0625 | default |
+---------------------+-------------+-----------------+----------+-------+---------+---------+
| Qwen2-0.5B-Instruct | general_qa  | bleu-4          | default  |    12 |  0.0556 | default |
+---------------------+-------------+-----------------+----------+-------+---------+---------+
| Qwen2-0.5B-Instruct | general_qa  | rouge-1-f       | default  |    12 |  0.3441 | default |
+---------------------+-------------+-----------------+----------+-------+---------+---------+
| Qwen2-0.5B-Instruct | general_qa  | rouge-1-p       | default  |    12 |  0.2393 | default |
+---------------------+-------------+-----------------+----------+-------+---------+---------+
| Qwen2-0.5B-Instruct | general_qa  | rouge-1-r       | default  |    12 |  0.8889 | default |
+---------------------+-------------+-----------------+----------+-------+---------+---------+
| Qwen2-0.5B-Instruct | general_qa  | rouge-2-f       | default  |    12 |  0.2062 | default |
+---------------------+-------------+-----------------+----------+-------+---------+---------+
| Qwen2-0.5B-Instruct | general_qa  | rouge-2-p       | default  |    12 |  0.1453 | default |
+---------------------+-------------+-----------------+----------+-------+---------+---------+
| Qwen2-0.5B-Instruct | general_qa  | rouge-2-r       | default  |    12 |  0.6167 | default |
+---------------------+-------------+-----------------+----------+-------+---------+---------+
| Qwen2-0.5B-Instruct | general_qa  | rouge-l-f       | default  |    12 |  0.333  | default |
+---------------------+-------------+-----------------+----------+-------+---------+---------+
| Qwen2-0.5B-Instruct | general_qa  | rouge-l-p       | default  |    12 |  0.2324 | default |
+---------------------+-------------+-----------------+----------+-------+---------+---------+
| Qwen2-0.5B-Instruct | general_qa  | rouge-l-r       | default  |    12 |  0.8889 | default |
+---------------------+-------------+-----------------+----------+-------+---------+---------+
```
