<p align="center">
  <p align="center">
    <h1 align="center">ResFields: Residual Neural Fields for Spatiotemporal Signals</h1>
  </p>
  <h2 align="center"></h2>
  <div align="center"></div> 

<p>
ResField layers incorporate time-dependent weights into MLPs to effectively represent complex temporal signals. 
</p>

## Applications


|                              ![Video](assets/cat.gif)                              |                                                ![TSDF](assets/tsdf.gif)                                                   |
| :--------------------------------------------------------------------------------: | :-----------------------------------------------------------------------------------------------------------------------: |
|                               2D Video Approximation                               |                                                   Temporal SDF Capture                                                    |
|                               ![TNeRF](assets/tnerf.gif)                           |                                            ![TNeRF_RGBD](assets/tnerf_rgbd.gif)                                           |
|                              Dynamic NeRFs from 4 RGB views                        |                                                   Dynamic NeRFs from 3 RGB-D                                              |


## News :triangular_flag_on_post:
- [2023/10/01] Code released. 

## Key idea of ResFields
Our key idea is to substitute one or several MLP layers with time-dependent layers whose weights are modeled as trainable residual parameters added to the existing layer weights.


We propose to implement the residual parameters as a global low-rank spanning set and a set of time-dependent coefficients. this modeling enhances the generalization properties and further reduces the memory footprint caused by maintaining additional network parameters. 

These residual weights are modeled as a learnable low-rank composition.

Increasing the model capacity in this way offers three key advantages:

1) **Runtime**: the underlying MLP does not increase in size and hence maintains the inference and training speed.
2) **Generalizability**: retains the implicit regularization and generalization properties of MLPs.
3) **Universality**: ResFields are versatile, easily extendable, and compatible with most MLP-based methods for spatiotemporal signals.


<details><summary>Please consider citing our work if you find it useful</summary>

</details>
<br>

## Instructions
- See [installation](docs/installation.md) to install all the required packages
- See [data preparation](docs/data.md) to set up the datasets
- See [benchmark](docs/benchmark.md) on how to run various experiments and reproduce results from the paper

## License
The code and models are available for use without any restrictions. 
See the [LICENSE](LICENSE) file for details. 
