import pickle


# -------------------------------- Convergence curves --------------------------------
# takes progression prepares br against average strategy for the plot
def create_plotable_progression_avg_br(data):
    return [[value[0] for value in data], "Best response to average strategy", "b-"]


# takes progression prepares br against current strategy for the plot
def create_plotable_progression_current_br(data):
    return [[value[1] for value in data], "Best response to current strategy", "g--"]


# takes progression prepares qr against average strategy for the plot
def create_plotable_progression_avg_qr(data):
    return [[value[2] for value in data], "Quantal response to average strategy", "r-"]


# takes progression prepares qr against current strategy for the plot
def create_plotable_progression_current_qr(data):
    return [[value[3] for value in data], "Quantal response to current strategy", "c--"]


# takes progression and prepares qr and br against average strategy for the plot
def create_plotable_progression_avg_br_qr(data):
    return create_plotable_progression_avg_br(data), create_plotable_progression_avg_qr(data)


# takes progression and prepares qr and br against current strategy for the plot
def create_plotable_progression_current_br_qr(data):
    return create_plotable_progression_current_br(data), create_plotable_progression_current_qr(data)


# takes progression and prepares br against both current and average strategy for the plot
def create_plotable_progression_both_br(data):
    return create_plotable_progression_current_br(data), create_plotable_progression_avg_br(data)


# takes progression and prepares qr against both current and average strategy for the plot
def create_plotable_progression_both_qr(data):
    return create_plotable_progression_current_qr(data), create_plotable_progression_avg_qr(data)


# prepares whole progression for the plot
def create_plotable_progression(data):
    return create_plotable_progression_current_br(data), create_plotable_progression_current_qr(
        data), create_plotable_progression_avg_br(data), create_plotable_progression_avg_qr(data)


# already good curve and I add name and axis
def data_for_graph_of_convergence_curve(algorithm, fname, rationality):
    name = get_name("Convergence curve of", algorithm, fname, rationality)
    axis_labes = ["Iterations", "Expected value"]
    return name, axis_labes


# labels for axis and curves
def data_for_graph_of_exploitability_curve(algorithm, fname, rationality):
    name = get_name("Exploitation and exploitability curves of", algorithm, fname, rationality)
    axis_labes = ["Iterations", "Value gained and value lost"]
    return name, axis_labes


# labels for axis and curves
def data_for_graph_exploitability_on_axis(algorithm, fname, rationality):
    name = get_name("Exploitation and exploitability curve of", algorithm, fname, rationality)
    axis_labes = ["Exploitability", "Exploitation"]
    return name, axis_labes


# labels for axis and curves
def data_for_graph_of_exploitability_curve_rationality(algorithm, fname, rationality):
    name = get_name("Exploitation and exploitability curves of", algorithm, fname, rationality)
    axis_labes = ["Rationality", "Expected value"]
    return name, axis_labes


def data_for_graph_of_rqr(algorithm, fname, rationality):
    name = get_name("Value of", algorithm, fname, rationality)
    axis_labes = ["p", "Expected value"]
    return name, axis_labes


def get_name(start, algorithm, fname, rationality):
    return start + " " + algorithm + " on game " + fname.replace("data/", "").replace(
        ".efg", "").replace(".gbt", "") + ("" if rationality is None else " with rationality " + str(rationality))


# saves serializable data to file
def save_to_file(save, fname):
    with open(fname, "wb") as pickle_out:
        pickle.dump(save, pickle_out, pickle.HIGHEST_PROTOCOL)


# saves data from file
def load_from_file(fname):
    with open(fname, "rb") as pickle_in:
        return pickle.load(pickle_in)
