from ExtensiveGame import ExtensiveGame
from ExtensiveGame import Node


class GenerateRNRGame:
    def __init__(self, fname_in):
        # save filenames for later use
        self.fname_in = fname_in
        self.fname_out = None

        # create the game
        self.game = ExtensiveGame()
        self.game.load(fname_in)

        # save player and his strategy
        self.fixed_player = None
        self.acting_player = None
        self.strategies = None

        # create resulting game
        self.resulting_game = ExtensiveGame()
        self.p = None

    def generate(self, fname_out, p, fixed_player, strategies):
        self.fixed_player = fixed_player
        self.acting_player = 1 - fixed_player
        self.strategies = strategies
        self.fname_out = fname_out
        self.p = p
        assert sum(self.p) == 1

        self.resulting_game.root = Node(2, 0, None, self.game.getid())
        self.resulting_game.root.chance = self.p

        player = self.game.root.player
        nodes_fix = []
        if player == 2:
            node_br = Node(2, 0, self.resulting_game.root, self.game.root.id_val)
            self.resulting_game.root.children.append(node_br)
            for _ in self.strategies:
                node_fix = Node(2, 0, self.resulting_game.root, self.game.getid())
                self.resulting_game.root.children.append(node_fix)
                nodes_fix.append(node_fix)
        elif player == self.fixed_player:
            node_br = Node(player, self.game.root.i_set, self.resulting_game.root, self.game.root.id_val)
            self.resulting_game.root.children.append(node_br)
            for _ in self.strategies:
                node_fix = Node(2, 0, self.resulting_game.root, self.game.getid())
                self.resulting_game.root.children.append(node_fix)
                nodes_fix.append(node_fix)
        elif player == self.acting_player:
            node_br = Node(player, self.game.root.i_set, self.resulting_game.root, self.game.root.id_val)
            self.resulting_game.root.children.append(node_br)
            for _ in self.strategies:
                node_fix = Node(player, self.game.root.i_set, self.resulting_game.root, self.game.getid())
                self.resulting_game.root.children.append(node_fix)
                nodes_fix.append(node_fix)
        else:
            raise Exception("Root is terminal node.")
        self.generate_step(self.game.root, node_br, nodes_fix)
        self.resulting_game.save_to_file(self.fname_out)

    def create_children(self, child, parent_br, parents_fix):
        player = child.player
        terminate = False
        children_fix = []
        if player == 3:
            child_br = Node(player, child.i_set, parent_br, child.id_val, child.value)
            parent_br.children.append(child_br)
            for parent_fix in parents_fix:
                child_fix = Node(player, child.i_set, parent_fix, self.game.getid(), child.value)
                parent_fix.children.append(child_fix)
                children_fix.append(child_fix)
            terminate = True
        elif player == 2:
            child_br = Node(player, 0, parent_br, child.id_val)
            parent_br.children.append(child_br)
            for parent_fix in parents_fix:
                child_fix = Node(player, 0, parent_fix, self.game.getid())
                parent_fix.children.append(child_fix)
                children_fix.append(child_fix)
        elif player == self.fixed_player:
            child_br = Node(child.player, child.i_set, parent_br, child.id_val)
            parent_br.children.append(child_br)
            for parent_fix in parents_fix:
                child_fix = Node(2, 0, parent_fix, self.game.getid())
                parent_fix.children.append(child_fix)
                children_fix.append(child_fix)
        elif player == self.acting_player:
            child_br = Node(player, child.i_set, parent_br, child.id_val)
            parent_br.children.append(child_br)
            for parent_fix in parents_fix:
                child_fix = Node(player, child.i_set, parent_fix, self.game.getid())
                parent_fix.children.append(child_fix)
                children_fix.append(child_fix)
        else:
            raise Exception("Wrong player number.")
        return child_br, children_fix, terminate

    def next_step(self, node, node_br, node_fix):
        for child in node.children:
            child_br, children_fix, terminate = self.create_children(child, node_br, node_fix)
            if not terminate:
                self.generate_step(child, child_br, children_fix)

    def generate_step(self, node, node_br, nodes_fix):
        player = node.player
        node_br.labels = node.labels
        for node_fix in nodes_fix:
            node_fix.labels = node.labels
        if player == 2:
            node_br.chance = node.chance
            for node_fix in nodes_fix:
                node_fix.chance = node.chance
            self.next_step(node, node_br, nodes_fix)
        elif player == self.fixed_player:
            for i, node_fix in enumerate(nodes_fix):
                node_fix.chance = self.strategies[i][node.i_set]
            self.next_step(node, node_br, nodes_fix)
        elif player == self.acting_player:
            self.next_step(node, node_br, nodes_fix)
