from ExtensiveGame import ExtensiveGame
from ExtensiveGame import Node
from GenerateRnRGame import GenerateRNRGame


class GenerateRNRGameNotFixed(GenerateRNRGame):
    new_iset = None

    def generate(self, fname_out, p, fixed_player, strategies):
        self.fixed_player = fixed_player
        self.acting_player = 1 - fixed_player
        self.strategies = strategies
        self.fname_out = fname_out
        self.p = p
        assert sum(self.p) == 1
        self.new_iset = len(self.game.isets_p1) if self.fixed_player == 0 else len(self.game.isets_p2)
        self.new_isets = {}

        self.resulting_game.root = Node(2, 0, None, self.game.getid())
        self.resulting_game.root.chance = self.p

        player = self.game.root.player
        nodes_fix = []
        if player == 2:
            node_br = Node(2, 0, self.resulting_game.root, self.game.root.id_val)
            node_br.labels = self.game.root.labels
            self.resulting_game.root.children.append(node_br)
            for _ in self.strategies:
                node_fix = Node(2, 0, self.resulting_game.root, self.game.getid())
                node_fix.labels = self.game.root.labels
                self.resulting_game.root.children.append(node_fix)
                nodes_fix.append(node_fix)
        elif player == self.fixed_player or player == self.acting_player:
            node_br = Node(player, self.game.root.i_set, self.resulting_game.root, self.game.root.id_val)
            node_br.labels = self.game.root.labels
            self.resulting_game.root.children.append(node_br)
            for _ in self.strategies:
                if player == self.fixed_player:
                    node_fix = Node(player, self.new_iset, self.resulting_game.root, self.game.getid())
                    node_fix.labels = self.game.root.labels
                    self.new_isets[self.game.root.i_set] = self.new_iset
                    self.new_iset += 1
                else:
                    node_fix = Node(player, self.game.root.i_set, self.resulting_game.root, self.game.getid())
                    node_fix.labels = self.game.root.labels
                self.resulting_game.root.children.append(node_fix)
                nodes_fix.append(node_fix)
        else:
            raise Exception("Root is terminal node.")
        self.generate_step(self.game.root, node_br, nodes_fix)
        self.resulting_game.save_to_file(self.fname_out)

    def create_children(self, child, parent_br, parents_fix):
        player = child.player
        terminate = False
        children_fix = []
        if player == 3:
            child_br = Node(player, child.i_set, parent_br, child.id_val, child.value)
            parent_br.children.append(child_br)
            for parent_fix in parents_fix:
                child_fix = Node(player, child.i_set, parent_fix, self.game.getid(), child.value)
                parent_fix.children.append(child_fix)
                children_fix.append(child_fix)
            terminate = True
        elif player == 2:
            child_br = Node(player, 0, parent_br, child.id_val)
            parent_br.children.append(child_br)
            for parent_fix in parents_fix:
                child_fix = Node(player, 0, parent_fix, self.game.getid())
                parent_fix.children.append(child_fix)
                children_fix.append(child_fix)
        elif player == self.fixed_player or player == self.acting_player:
            child_br = Node(player, child.i_set, parent_br, child.id_val)
            parent_br.children.append(child_br)
            for parent_fix in parents_fix:
                if player == self.fixed_player:
                    if child.i_set in self.new_isets:
                        child_fix = Node(player, self.new_isets[child.i_set], parent_fix, self.game.getid())
                    else:
                        child_fix = Node(player, self.new_iset, parent_fix, self.game.getid())
                        self.new_isets[child.i_set] = self.new_iset
                        self.new_iset += 1
                else:
                    child_fix = Node(player, child.i_set, parent_fix, self.game.getid())
                parent_fix.children.append(child_fix)
                children_fix.append(child_fix)
        else:
            raise Exception("Wrong player number.")
        return child_br, children_fix, terminate
