# Getting Started
For local runs, you need  mxnet >= 1.6 and the
packages in [requirements_local.txt](requirements_local.txt) that you can install with

`pip install -r requirements_local.txt`

You also need to run `pip install -e .` from the main directory
to install the gluonts fork.

If using sagemaker, fill in the missing information in [src/train_eval.py](src/train_eval.py), [mang.py](mang.py) and [sagemaker_util.py](sagemaker_util.py).

The M3 and Tourism Datasets will have to be manually downloaded and put in the folder indicated by the error message of the first run that requires them.

# Experiments

For running experiments use the [run.py](run.py) script.
We use the sacred library to track configurations and results.

The experiment in the paper can be run using the scripts in the [exp_paper_scripts](exp_paper_scripts/) directory.

For HPO (hyperparameter optimization) runs the [run_ensemble_local.py](run_ensemble_local.py)
script is used to select the best runs and compute the ensembles according to the metric of choice.

The configuration is defined in [src/expconfig.py](src/expconfig.py).

Here are some examples for launching experiments

```
./run.py with model_name=deepar monthly_full local
./run.py with model_name=meta_glar monthly_full local
./run.py with model_name=nbeats_sh monthly_full  local
```

The `local` flag means that you will run locally (if this is not provided a sagemaker run is triggered).

You can use `print_config` to see the configuration for a run
```
./run.py print_config with model_name=meta_glar train=m4_monthly test=m3_monthly local
```
and can overwrite any of the configurations you see
```
./run.py with model_name=meta_glar train=m4_monthly test=m3_monthly local trainer.num_batches_per_epoch=1
```

## Results

Each run gets a `run_id` the results are stored under `./my_runs/meta/<run_id>`
if you run locally, otherwise on s3.

## Dummy runs

To quickly test something out you can do a dummy run by adding `dummy`: 
```
./run.py with model_name=meta_glar train=m4_monthly test=m3_monthly local dummy
```
This will set `epochs=1`, `trainer.num_batches_per_epoch=1`, and `evaluation.limit_examples=1` and also set a `is_dummy_run` flag.

You can also set the dummy flag directly without changing any of the other parameters.
```
./run.py with model_name=meta_glar train=m4_monthly test=m3_monthly local is_dummy_run=True
```

Note: If your git workspace is dirty you are only allowed to do dummy runs.

# Implementation Details
The Meta-GLAR method, together with all the ablation considered by our experiments is implemented in [src/gluonts/model/meta_autoreg_det](../src/gluonts/model/meta_autoreg_det).
For DeepAR and NBEATS we use the gluonts classes.
