#!/usr/bin/env python
# coding: utf-8
import copy
import hashlib
import multiprocessing as mp
import sys
import logging
import uuid

logging.basicConfig(stream=sys.stdout, level=logging.INFO)

sys.path.insert(0, "./src")


if __name__ == "__main__":
    mp.set_start_method("spawn", force=True)

    from src.expconfig import ex
    import sagemaker_util
    import sys

    argv = sys.argv

    curex = copy.copy(ex)

    @curex.main
    def parse(_config):
        hpo_params = _config["hpo"]["params"]
        hpo_error_msg = (
            "hpo.params could not be parsed correctly. "
            "It should be a list of dictionaries with strings as keys and values. "
            "User print_config to check how the value is parsed."
        )
        assert isinstance(hpo_params, (list, tuple)), hpo_error_msg
        for p in hpo_params:
            assert isinstance(p, dict), hpo_error_msg
        return _config

    print(f"argv = {argv}")

    parse_res = curex.run_commandline()
    if parse_res.meta_info["command"] != "parse":
        sys.exit(0)

    cfg = parse_res.result
    sm = cfg["sm"]

    sagemaker_util.train_eval_sagemaker(
        exp_name=cfg["exp_name"],
        run_local=sm["run_local"],
        wait=sm["wait"],
        instance_type=sm["instance_type"],
        volume_size=sm["volume_size"],
        config=cfg,
        argv=argv,
    )
