#!/bin/bash
# Training curves experiments (Meta-GLAR, DeepAR and NBEATS-SH)

expname=traincurve
l=  # if local runs locally, otherwise on sagemaker
for _ in {1..4}
do
python run.py with $l  monthly_full exp_name=$expname batch_size=128 model_name=rnn               history_len=40 context_length_mult=5 dim_transform=40 epochs=500 num_val_callback=8000 use_train_for_val=False eval_interval=20 patience=1000 iterate_forecasts_during_training=False
python run.py with $l  monthly_full exp_name=$expname batch_size=128 model_name=meta_glar         history_len=40 context_length_mult=5 dim_transform=40 epochs=500 num_val_callback=8000 use_train_for_val=False eval_interval=20 patience=1000 iterate_forecasts_during_training=True
python run.py with $l  monthly_full exp_name=$expname batch_size=1024 model_name=nbeats_sh_single history_len=40 context_length_mult=2                  epochs=100 num_val_callback=8000 use_train_for_val=False eval_interval=3  patience=1000
done