## Dataset generation
The code in this folder is adapted from the DC3 repo:
[https://github.com/locuslab/DC3/tree/main](https://github.com/locuslab/DC3/tree/main)
and can be used to generate the large datasets in our numerical experiments.
To do so, use the following commands:
```
conda create -n dc3env python==3.10.6
conda activate dc3env
pip install pip --upgrade
conda install -c conda-forge cyipopt==1.5.0
pip install numpy==1.26.4 torch==2.6.0 tqdm==4.67.1 osqp==0.6.7.post3 qpth==0.0.18
```
To generate the large convex dataset run:
```
python make_dataset_simple.py
python myutils_convex_dataset_to_npz.py
```
Then, move all the `*.npz`files from `datasets/simple/` to `hcnn-main/src/simple_QP/datasets/`.

To generate the large non-convex dataset run:
```
python make_dataset_nonconvex.py
python myutils_nonconvex_dataset_to_npz.py
```
Then, move all the `*.npz`files from `datasets/nonconvex/` to `pinet-main/src/benchmarks/QP/datasets/`.
