# Adaptive Soft-Actor Critic (Adadasac)

This repository contains the official implementation of Adadasac to accompany the paper.
The implementation is based on [Stable-Baselines3](https://github.com/DLR-RM/stable-baselines3) in Jax.

## Setup
Execute the following commands to set up a conda environment to run experiments
```bash
conda create -n adasac python=3.11.5
conda activate adasac
conda install -c nvidia cuda-nvcc=12.3.52

# conda install python=3.11.5
python -m pip install -e .
python -m pip install --upgrade "jax[cuda12_pip]" -f https://storage.googleapis.com/jax-releases/jax_cuda_releases.html
```

## Running Experiments
The main entry point for running experiments is the `train.py` file. The experiments can be controlled by passing the appropriate environment flags. For more info run `python train.py --help`.

With wandb logging enabled:
```bash
python train.py -algo adasac -env HumanoidStandup-v4 -seed 9 -wandb_mode 'online'
```

Without wandb but with tensorboard logging:
```bash
python train.py -algo adasac -env HumanoidStandup-v4 -seed 9 -wandb_mode 'disabled'
```
and in a separate terminal:
```bash
tensorboard --logdir ./logs
```

## Acknowledgements

This project is based on the [Stable-Baselines3](https://github.com/DLR-RM/stable-baselines3) in Jax repository.
