#!/bin/bash

source launch_job/parse_arguments.sh
parse_arguments $@

[ -d out/$ENV ] || mkdir -p out/$ENV

JOB_NAME=$ENV\LR-$LEARNING_RATES\OC-$OPTIMIZER_CLASSES\NAQ-$NET_ARCHS_QF\AF-$ACTIVATION_FNS-\RT-$RANDOM_TARGET_QF\EE-$END_EPSILON
PATH_NAME=out/$ENV/LR-$LEARNING_RATES\OC-$OPTIMIZER_CLASSES\NAQ-$NET_ARCHS_QF\AF-$ACTIVATION_FNS-\RT-$RANDOM_TARGET_QF\EE-$END_EPSILON\_%a.out

if [[ $ENV == "Hopper" ]]
then # parallelize training
    submission=$(sbatch -J $JOB_NAME --array=1-3 --cpus-per-task=4 --mem-per-cpu=2700M --time=10:00:00 --gres=gpu:1 -p gpu --prefer="rtx3090|a5000" --output=$PATH_NAME launch_job/launch_run_multi.sh $@)
    # submission=$(sbatch -J $JOB_NAME --array=4-4 --cpus-per-task=4 --mem-per-cpu=2G --time=10:00:00 --gres=gpu:1 -p gpu --prefer="rtx3090|a5000" --output=$PATH_NAME launch_job/launch_run.sh $@)
elif [[ $ENV == "Humanoid" || $ENV == "HumanoidStandup" ]]
then # higher memory
    submission=$(sbatch -J $JOB_NAME --array=1-9 --cpus-per-task=2 --mem-per-cpu=4G --time=10:00:00 --gres=gpu:1 -p gpu --prefer="rtx3090|a5000" --output=$PATH_NAME launch_job/launch_run.sh $@)
else
    submission=$(sbatch -J $JOB_NAME --array=1-9 --cpus-per-task=2 --mem-per-cpu=2G --time=10:00:00 --gres=gpu:1 -p gpu --prefer="rtx3090|a5000" --output=$PATH_NAME launch_job/launch_run.sh $@)
fi