#!/bin/bash

source launch_job/parse_arguments.sh
parse_arguments $@


if [[ $ENV == "Hopper" ]]
then # parallelize training
    train_command="launch_job/launch_run_multi.sh $@"
else 
    train_command="launch_job/launch_run.sh $@"
fi

for (( seed=$FIRST_SEED; seed<=$LAST_SEED; seed++ ))
do
    seed_command="export SLURM_ARRAY_TASK_ID=$seed"

    tmux send-keys -t train_asac "$seed_command" ENTER "$train_command" ENTER
done